/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.font;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.lwjgl.BufferUtils;

public final class GlyphPage {
    private int imageSize;
    private int maxHeight = -1;
    private final Font font;
    private final boolean antiAlias;
    private final boolean fractionalMetrics;
    private final HashMap<Character, Glyph> glyphs = new HashMap();
    private BufferedImage img;
    private class_1044 texture;

    public GlyphPage(Font font, boolean antiAlias, boolean fractionalMetrics) {
        this.font = font;
        this.antiAlias = antiAlias;
        this.fractionalMetrics = fractionalMetrics;
    }

    public void generate(char[] chars) {
        double width = -1.0;
        double height = -1.0;
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), this.antiAlias, this.fractionalMetrics);
        for (char item : chars) {
            Rectangle2D bounds = this.font.getStringBounds(Character.toString(item), frc);
            if (width < bounds.getWidth()) {
                width = bounds.getWidth();
            }
            if (!(height < bounds.getHeight())) continue;
            height = bounds.getHeight();
        }
        double maxWidth = width + 2.0;
        double maxHeight = height + 2.0;
        this.imageSize = (int)Math.ceil(Math.max(Math.ceil(Math.sqrt(maxWidth * maxWidth * (double)chars.length) / maxWidth), Math.ceil(Math.sqrt(maxHeight * maxHeight * (double)chars.length) / maxHeight)) * Math.max(maxWidth, maxHeight)) + 1;
        this.img = new BufferedImage(this.imageSize, this.imageSize, 2);
        Graphics2D graphics = this.img.createGraphics();
        graphics.setFont(this.font);
        graphics.setColor(new Color(255, 255, 255, 0));
        graphics.fillRect(0, 0, this.imageSize, this.imageSize);
        graphics.setColor(Color.white);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.fractionalMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        FontMetrics metrics = graphics.getFontMetrics();
        int currentHeight = 0;
        int posX = 0;
        int posY = 1;
        for (char c : chars) {
            Glyph glyph = new Glyph();
            Rectangle2D boundsx = metrics.getStringBounds(Character.toString(c), graphics);
            glyph.width = boundsx.getBounds().width + 8;
            glyph.height = boundsx.getBounds().height;
            if (posX + glyph.width >= this.imageSize) {
                posX = 0;
                posY += currentHeight;
                currentHeight = 0;
            }
            glyph.x = posX;
            glyph.y = posY;
            if (glyph.height > this.maxHeight) {
                this.maxHeight = glyph.height;
            }
            if (glyph.height > currentHeight) {
                currentHeight = glyph.height;
            }
            graphics.drawString(Character.toString(c), posX + 2, posY + metrics.getAscent());
            posX += glyph.width;
            this.glyphs.put(Character.valueOf(c), glyph);
        }
    }

    public void setup() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.img, "png", output);
            byte[] byteArray = output.toByteArray();
            ByteBuffer data = BufferUtils.createByteBuffer((int)byteArray.length).put(byteArray);
            data.flip();
            this.texture = new class_1043(class_1011.method_4324((ByteBuffer)data));
        }
        catch (Throwable var4) {
            var4.printStackTrace(System.err);
        }
    }

    public void bind() {
        if (this.texture != null) {
            RenderSystem.setShaderTexture((int)0, (int)this.texture.method_4624());
        }
    }

    public void unbind() {
        RenderSystem.setShaderTexture((int)0, (int)0);
    }

    public float drawChar(class_4587 stack, char ch, float x, float y, float r, float b, float g, float alpha) {
        Glyph glyph = this.glyphs.get(Character.valueOf(ch));
        if (glyph == null) {
            return 0.0f;
        }
        if (this.texture == null) {
            return 0.0f;
        }
        float pageX = (float)glyph.x / (float)this.imageSize;
        float pageY = (float)glyph.y / (float)this.imageSize;
        float pageWidth = (float)glyph.width / (float)this.imageSize;
        float pageHeight = (float)glyph.height / (float)this.imageSize;
        float width = glyph.width;
        float height = glyph.height;
        RenderSystem.setShader(class_757::method_34543);
        this.bind();
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        builder.method_22918(stack.method_23760().method_23761(), x, y + height, 0.0f).method_22915(r, g, b, alpha).method_22913(pageX, pageY + pageHeight);
        builder.method_22918(stack.method_23760().method_23761(), x + width, y + height, 0.0f).method_22915(r, g, b, alpha).method_22913(pageX + pageWidth, pageY + pageHeight);
        builder.method_22918(stack.method_23760().method_23761(), x + width, y, 0.0f).method_22915(r, g, b, alpha).method_22913(pageX + pageWidth, pageY);
        builder.method_22918(stack.method_23760().method_23761(), x, y, 0.0f).method_22915(r, g, b, alpha).method_22913(pageX, pageY);
        class_286.method_43433((class_9801)builder.method_60800());
        this.unbind();
        return width - 8.0f;
    }

    public float getWidth(char c) {
        Glyph glyph = this.glyphs.get(Character.valueOf(c));
        return glyph != null ? (float)glyph.width : 0.0f;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public boolean isFractionalMetrics() {
        return this.fractionalMetrics;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public static final class Glyph {
        private int x;
        private int y;
        private int width;
        private int height;

        Glyph(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        Glyph() {
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

