/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import skid.gypsyy.DonutBBC;
import skid.gypsyy.gui.ClickGUI;
import skid.gypsyy.gui.components.ModuleButton;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.utils.Animation;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.MathUtil;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.TextRenderer;
import skid.gypsyy.utils.Utils;

public final class CategoryWindow {
    public List<ModuleButton> moduleButtons = new ArrayList<ModuleButton>();
    public int x;
    public int y;
    private final int width;
    private final int height;
    public Color currentColor;
    private final Category category;
    public boolean dragging;
    public boolean extended;
    private int dragX;
    private int dragY;
    private int prevX;
    private int prevY;
    public ClickGUI parent;
    private float hoverAnimation = 0.0f;

    public CategoryWindow(int x, int y, int width, int height, Category category, ClickGUI parent) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.dragging = false;
        this.extended = true;
        this.height = height;
        this.category = category;
        this.parent = parent;
        this.prevX = x;
        this.prevY = y;
        ArrayList<Module> modules = new ArrayList<Module>(DonutBBC.INSTANCE.getModuleManager().keyCodec(category));
        int offset = height;
        for (Module module : modules) {
            this.moduleButtons.add(new ModuleButton(this, module, offset));
            offset += height;
        }
    }

    public void render(class_332 context, int n, int n2, float n3) {
        Color baseColor = new Color(25, 25, 25, skid.gypsyy.module.modules.client.DonutBBC.windowAlpha.getIntValue());
        this.currentColor = this.currentColor == null ? new Color(25, 25, 25, 0) : ColorUtil.interpolateAlpha(0.05f, baseColor.getAlpha(), this.currentColor);
        float n4 = this.isHovered(n, n2) && !this.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.approachValue(n3 * 0.1f, this.hoverAnimation, n4);
        Color hoverColor = new Color(255, 255, 255, 15);
        Color a = ColorUtil.keyCodec(new Color(25, 25, 25, this.currentColor.getAlpha()), hoverColor, this.hoverAnimation);
        float topLeft = 8.0f;
        float topRight = 8.0f;
        float bottomLeft = this.extended ? 0.0f : 8.0f;
        float bottomRight = this.extended ? 0.0f : 8.0f;
        RenderUtils.renderRoundedQuad(context.method_51448(), a, this.prevX, this.prevY, this.prevX + this.width, this.prevY + this.height, topLeft, topRight, bottomLeft, bottomRight, 50.0);
        Color mainColor = Utils.getMainColor(255, this.category.ordinal());
        CharSequence f = this.category.name;
        int n7 = this.prevX + (this.width - TextRenderer.getWidth(this.category.name)) / 2;
        int n8 = this.prevY + 8;
        Color textColor = ColorUtil.keyCodec(new Color(180, 180, 180), mainColor, this.hoverAnimation * 0.5f);
        TextRenderer.drawString(f, context, n7, n8, textColor.getRGB());
        this.updateButtons(n3);
        if (this.extended) {
            this.renderModuleButtons(context, n, n2, n3);
        }
    }

    private void renderModuleButtons(class_332 context, int n, int n2, float n3) {
        for (ModuleButton module : this.moduleButtons) {
            module.render(context, n, n2, n3);
        }
    }

    public void keyPressed(int n, int n2, int n3) {
        for (ModuleButton moduleButton : this.moduleButtons) {
            moduleButton.keyPressed(n, n2, n3);
        }
    }

    public void onGuiClose() {
        this.currentColor = null;
        for (ModuleButton moduleButton : this.moduleButtons) {
            moduleButton.onGuiClose();
        }
        this.dragging = false;
    }

    public void mouseClicked(double x, double y, int button) {
        if (this.isHovered(x, y)) {
            switch (button) {
                case 0: {
                    if (this.parent.method_25397()) break;
                    this.dragging = true;
                    this.dragX = (int)(x - (double)this.x);
                    this.dragY = (int)(y - (double)this.y);
                }
            }
        }
        if (this.extended) {
            for (ModuleButton moduleButton : this.moduleButtons) {
                moduleButton.mouseClicked(x, y, button);
            }
        }
    }

    public void mouseDragged(double n, double n2, int n3, double n4, double n5) {
        if (this.extended) {
            for (ModuleButton moduleButton : this.moduleButtons) {
                moduleButton.mouseDragged(n, n2, n3, n4, n5);
            }
        }
    }

    public void updateButtons(float n) {
        int height = this.height;
        for (ModuleButton next : this.moduleButtons) {
            Animation animation = next.animation;
            double n2 = next.extended ? (double)(this.height * (next.settings.size() + 1)) : (double)this.height;
            animation.animate(0.5 * (double)n, n2);
            double animation2 = next.animation.getAnimation();
            next.offset = height;
            height += (int)animation2;
        }
    }

    public void mouseReleased(double n, double n2, int n3) {
        if (n3 == 0 && this.dragging) {
            this.dragging = false;
        }
        if (this.extended) {
            for (ModuleButton moduleButton : this.moduleButtons) {
                moduleButton.mouseReleased(n, n2, n3);
            }
        }
    }

    public void mouseScrolled(double n, double n2, double n3, double n4) {
        this.prevX = this.x;
        this.prevY = this.y;
        this.prevY += (int)(n4 * 20.0);
        this.setY((int)((double)this.y + n4 * 20.0));
    }

    public int getX() {
        return this.prevX;
    }

    public int getY() {
        return this.prevY;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isHovered(double n, double n2) {
        return n > (double)this.x && n < (double)(this.x + this.width) && n2 > (double)this.y && n2 < (double)(this.y + this.height);
    }

    public boolean isPrevHovered(double n, double n2) {
        return n > (double)this.prevX && n < (double)(this.prevX + this.width) && n2 > (double)this.prevY && n2 < (double)(this.prevY + this.height);
    }

    public void updatePosition(double n, double n2, float n3) {
        this.prevX = this.x;
        this.prevY = this.y;
        if (this.dragging) {
            double n4 = this.isHovered(n, n2) ? (double)this.x : (double)this.prevX;
            this.x = (int)MathUtil.approachValue(0.3f * n3, n4, n - (double)this.dragX);
            double n5 = this.isHovered(n, n2) ? (double)this.y : (double)this.prevY;
            this.y = (int)MathUtil.approachValue(0.3f * n3, n5, n2 - (double)this.dragY);
        }
    }

    private static byte[] vbfixpesqoeicux() {
        return new byte[]{9, 39, 37, 116, 77, 48, 79, 112, 77, 114, 96, 59, 15, 85, 93, 58, 76, 29, 27, 107, 82, 38, 14, 37, 19, 125, 30, 87, 69, 24, 57, 76, 124, 68, 96, 106, 110, 78, 64, 115, 65, 67, 26, 55, 98, 72, 35, 74, 102, 123, 44, 126, 22, 89, 36, 23, 52, 71, 16, 27, 110, 57, 122, 56, 81, 70, 17, 14, 88, 36, 66, 45, 125, 98, 117, 60, 90, 125, 23, 122, 79, 93, 89, 126, 41, 19, 46, 6, 22, 9, 25};
    }
}

