/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import skid.gypsyy.DonutBBC;
import skid.gypsyy.gui.CategoryWindow;
import skid.gypsyy.gui.components.BlocksBox;
import skid.gypsyy.gui.components.BlocksFilter;
import skid.gypsyy.gui.components.FriendsBox;
import skid.gypsyy.gui.components.FriendsFilter;
import skid.gypsyy.gui.components.ItemBox;
import skid.gypsyy.gui.components.ItemFilter;
import skid.gypsyy.gui.components.MacroBox;
import skid.gypsyy.gui.components.MacroFilter;
import skid.gypsyy.gui.components.StringBox;
import skid.gypsyy.gui.components.TextBox;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BindSetting;
import skid.gypsyy.module.setting.BlocksSetting;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.ColorSetting;
import skid.gypsyy.module.setting.FriendsSetting;
import skid.gypsyy.module.setting.ItemSetting;
import skid.gypsyy.module.setting.MacroSetting;
import skid.gypsyy.module.setting.MinMaxSetting;
import skid.gypsyy.module.setting.ModeSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.module.setting.Setting;
import skid.gypsyy.module.setting.StringSetting;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.KeyUtils;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.TextRenderer;

public final class ClickGUI
extends class_437 {
    public Color currentColor;
    private static final Color BG_DEEPEST = new Color(8, 8, 12, 250);
    private static final Color BG_DEEP = new Color(14, 14, 20, 240);
    private static final Color BG_CARD = new Color(20, 20, 28, 230);
    private static final Color BG_ELEVATED = new Color(28, 28, 38, 220);
    private static final Color BG_HOVER = new Color(35, 35, 48, 200);
    private static final Color ACCENT_PRIMARY = new Color(124, 58, 237);
    private static final Color ACCENT_GLOW = new Color(167, 139, 250);
    private static final Color ACCENT_SECONDARY = new Color(59, 130, 246);
    private static final Color ACCENT_TERTIARY = new Color(236, 72, 153);
    private static final Color TEXT_PRIMARY = new Color(248, 250, 252);
    private static final Color TEXT_SECONDARY = new Color(203, 213, 225);
    private static final Color TEXT_MUTED = new Color(148, 163, 184);
    private static final Color TEXT_DIM = new Color(100, 116, 139);
    private static final Color SUCCESS = new Color(34, 197, 94);
    private static final Color ERROR = new Color(239, 68, 68);
    private static final Color DIVIDER = new Color(51, 65, 85, 100);
    private int guiX = -1;
    private int guiY = -1;
    private final int GUI_WIDTH = 980;
    private final int GUI_HEIGHT = 640;
    private final int SIDEBAR_WIDTH = 240;
    private final int HEADER_HEIGHT = 72;
    private final int PADDING = 20;
    private final int CARD_RADIUS = 14;
    private List<CategoryWindow> reaperWindows;
    private CharSequence tooltipText;
    private int tooltipX;
    private int tooltipY;
    private final Color DESCRIPTION_BG = new Color(40, 40, 40, 200);
    private Category selectedCategory = Category.CRYSTAL;
    private Module selectedModule = null;
    private String searchQuery = "";
    private boolean isSearchFocused = false;
    private int moduleScrollOffset = 0;
    private int settingsScrollOffset = 0;
    private final Map<Category, Float> categoryHoverAnim = new HashMap<Category, Float>();
    private final Map<Module, Float> moduleHoverAnim = new HashMap<Module, Float>();
    private float panelTransition = 0.0f;
    private float searchPulse = 0.0f;
    private float globalTime = 0.0f;
    private boolean isDragging = false;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private boolean isDraggingSlider = false;
    private Setting draggedSetting = null;
    private boolean draggedIsMin = false;

    public void method_25426() {
        super.method_25426();
        int screenW = class_310.method_1551().method_22683().method_4480();
        int screenH = class_310.method_1551().method_22683().method_4507();
        this.guiX = (screenW - 980) / 2;
        this.guiY = (screenH - 640) / 2;
    }

    public ClickGUI() {
        super((class_2561)class_2561.method_43473());
        Category[] categories;
        for (Category cat : Category.values()) {
            this.categoryHoverAnim.put(cat, Float.valueOf(0.0f));
        }
        this.reaperWindows = new ArrayList<CategoryWindow>();
        int windowX = 50;
        for (Category category : categories = Category.values()) {
            this.reaperWindows.add(new CategoryWindow(windowX, 50, 230, 30, category, this));
            windowX += 250;
        }
    }

    private boolean shouldUseReaperGUI() {
        return skid.gypsyy.module.modules.client.DonutBBC.OpenGui();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.shouldUseReaperGUI()) {
            if (class_310.method_1551().field_1755 == this) {
                int targetAlpha;
                if (DonutBBC.INSTANCE.screen != null) {
                    DonutBBC.INSTANCE.screen.method_25394(context, 0, 0, delta);
                }
                this.currentColor = this.currentColor == null ? new Color(0, 0, 0, 0) : new Color(0, 0, 0, this.currentColor.getAlpha());
                int alpha = this.currentColor.getAlpha();
                int n = targetAlpha = skid.gypsyy.module.modules.client.DonutBBC.renderBackground.getValue() ? 200 : 0;
                if (alpha != targetAlpha) {
                    this.currentColor = ColorUtil.keyCodec(0.05f, targetAlpha, this.currentColor);
                }
                if (class_310.method_1551().field_1755 instanceof ClickGUI) {
                    context.method_25294(0, 0, class_310.method_1551().method_22683().method_4480(), class_310.method_1551().method_22683().method_4507(), this.currentColor.getRGB());
                }
                RenderUtils.unscaledProjection();
                int scaledMouseX = mouseX * (int)class_310.method_1551().method_22683().method_4495();
                int scaledMouseY = mouseY * (int)class_310.method_1551().method_22683().method_4495();
                super.method_25394(context, scaledMouseX, scaledMouseY, delta);
                for (CategoryWindow window : this.reaperWindows) {
                    window.render(context, scaledMouseX, scaledMouseY, delta);
                    window.updatePosition(scaledMouseX, scaledMouseY, delta);
                }
                if (this.tooltipText != null) {
                    this.renderReaperTooltip(context, this.tooltipText, this.tooltipX, this.tooltipY);
                    this.tooltipText = null;
                }
                RenderUtils.scaledProjection();
            }
        } else {
            int scaledMouseX = (int)((double)mouseX * class_310.method_1551().method_22683().method_4495());
            int scaledMouseY = (int)((double)mouseY * class_310.method_1551().method_22683().method_4495());
            RenderUtils.unscaledProjection();
            this.globalTime += delta * 0.05f;
            this.panelTransition = Math.min(1.0f, this.panelTransition + delta * 0.08f);
            this.searchPulse = (float)Math.sin(this.globalTime * 2.0f) * 0.5f + 0.5f;
            this.renderBackdrop(context);
            this.renderMainContainer(context, scaledMouseX, scaledMouseY, delta);
            RenderUtils.scaledProjection();
        }
    }

    private void renderReaperTooltip(class_332 drawContext, CharSequence charSequence, int x, int y) {
        if (charSequence != null && charSequence.length() != 0) {
            int framebufferWidth;
            int width = TextRenderer.getWidth(charSequence);
            if (x + width + 10 > (framebufferWidth = class_310.method_1551().method_22683().method_4489())) {
                x = framebufferWidth - width - 10;
            }
            RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.DESCRIPTION_BG, x - 5, y - 5, x + width + 5, y + 15, 6.0, 6.0, 6.0, 6.0, 50.0);
            TextRenderer.drawString(charSequence, drawContext, x, y, Color.WHITE.getRGB());
        }
    }

    public void setTooltip(CharSequence tooltipText, int tooltipX, int tooltipY) {
        this.tooltipText = tooltipText;
        this.tooltipX = tooltipX;
        this.tooltipY = tooltipY;
    }

    private void renderBackdrop(class_332 context) {
        int screenW = class_310.method_1551().method_22683().method_4480();
        int screenH = class_310.method_1551().method_22683().method_4507();
        Color gradTop = new Color(6, 6, 10, 200);
        Color gradBot = new Color(15, 10, 25, 220);
        context.method_25296(0, 0, screenW, screenH, gradTop.getRGB(), gradBot.getRGB());
        long time = System.currentTimeMillis();
        float orb1X = (float)((double)screenW * 0.2 + Math.sin((double)time / 8000.0) * 150.0);
        float orb1Y = (float)((double)screenH * 0.3 + Math.cos((double)time / 6000.0) * 100.0);
        this.renderGlowOrb(context, orb1X, orb1Y, 180.0f, ACCENT_PRIMARY, 3);
        float orb2X = (float)((double)screenW * 0.75 + Math.cos((double)time / 7000.0) * 120.0);
        float orb2Y = (float)((double)screenH * 0.6 + Math.sin((double)time / 9000.0) * 80.0);
        this.renderGlowOrb(context, orb2X, orb2Y, 140.0f, ACCENT_SECONDARY, 2);
        float orb3X = (float)((double)screenW * 0.5 + Math.sin((double)time / 5000.0) * 100.0);
        float orb3Y = (float)((double)screenH * 0.8 + Math.cos((double)time / 8000.0) * 60.0);
        this.renderGlowOrb(context, orb3X, orb3Y, 100.0f, ACCENT_TERTIARY, 2);
    }

    private void renderGlowOrb(class_332 context, float x, float y, float size, Color color, int layers) {
        for (int i = layers; i > 0; --i) {
            float layerSize = size * (1.0f - (float)i * 0.2f);
            int alpha = 2 + i * 2;
            Color layerColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            RenderUtils.renderCircle(context.method_51448(), layerColor, x, y, layerSize, 32);
        }
    }

    private void renderMainContainer(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderDropShadow(context, this.guiX, this.guiY, 980, 640);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), BG_DEEPEST, this.guiX, this.guiY, 980.0, 640.0, 14.0, 120.0);
        Color borderGlow = new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), 40);
        RenderUtils.renderRoundedOutline(context, borderGlow, this.guiX, this.guiY, this.guiX + 980, this.guiY + 640, 14.0, 14.0, 14.0, 14.0, 1.5, 120.0);
        this.renderHeader(context, mouseX, mouseY);
        this.renderSidebar(context, mouseX, mouseY, delta);
        this.renderContent(context, mouseX, mouseY, delta);
        if (this.selectedModule != null) {
            this.renderSettingsPanel(context, mouseX, mouseY, delta);
        }
    }

    private void renderDropShadow(class_332 context, int x, int y, int width, int height) {
        int shadowSize = 20;
        for (int i = 0; i < shadowSize; ++i) {
            int alpha = (shadowSize - i) * 3;
            Color shadowColor = new Color(0, 0, 0, alpha);
            RenderUtils.renderRoundedQuadShader(context.method_51448(), shadowColor, x - i, y - i, width + i * 2, height + i * 2, 14 + i, 80.0);
        }
    }

    private void renderHeader(class_332 context, int mouseX, int mouseY) {
        RenderUtils.renderRoundedQuadShader(context.method_51448(), BG_DEEP, this.guiX, this.guiY, 980.0, 72.0, 14.0, 100.0);
        int lineY = this.guiY + 72 - 1;
        context.method_25296(this.guiX + 20, lineY, this.guiX + 980 - 20, lineY + 2, new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), 80).getRGB(), new Color(ACCENT_TERTIARY.getRed(), ACCENT_TERTIARY.getGreen(), ACCENT_TERTIARY.getBlue(), 80).getRGB());
        int titleX = this.guiX + 20 + 8;
        int titleY = this.guiY + 24;
        RenderUtils.renderCircle(context.method_51448(), ACCENT_PRIMARY, titleX + 12, titleY + 12, 12.0, 16);
        RenderUtils.renderCircle(context.method_51448(), ACCENT_GLOW, titleX + 12, titleY + 12, 8.0, 16);
        TextRenderer.drawString("KRISPY", context, titleX + 38, titleY + 3, TEXT_PRIMARY.getRGB());
        TextRenderer.drawString("CLIENT", context, titleX + 38, titleY + 14, TEXT_MUTED.getRGB());
        int versionX = titleX + 130;
        int versionY = titleY + 5;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), 80), versionX, versionY, 50.0, 18.0, 9.0, 60.0);
        TextRenderer.drawCenteredString("v1.3", context, versionX + 25, versionY + 5, ACCENT_GLOW.getRGB());
        int btnY = this.guiY + 18;
        int closeX = this.guiX + 980 - 20 - 36;
        boolean closeHovered = this.isPointInRect(mouseX, mouseY, closeX, btnY, 36, 36);
        Color closeBg = closeHovered ? new Color(ERROR.getRed(), ERROR.getGreen(), ERROR.getBlue(), 120) : new Color(BG_ELEVATED.getRed(), BG_ELEVATED.getGreen(), BG_ELEVATED.getBlue(), 100);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), closeBg, closeX, btnY, 36.0, 36.0, 10.0, 60.0);
        Color textColor = closeHovered ? TEXT_PRIMARY : TEXT_SECONDARY;
        TextRenderer.drawCenteredString("\u2715", context, closeX + 18, btnY + 11, textColor.getRGB());
    }

    private void renderSidebar(class_332 context, int mouseX, int mouseY, float delta) {
        Category[] categories;
        int sidebarX = this.guiX;
        int sidebarY = this.guiY + 72;
        int sidebarH = 568;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), BG_DEEP, sidebarX, sidebarY, 240.0, sidebarH, 0.0, 100.0);
        int contentY = sidebarY + 20;
        TextRenderer.drawString("CATEGORIES", context, sidebarX + 20, contentY, TEXT_DIM.getRGB());
        contentY += 32;
        for (Category cat : categories = Category.values()) {
            boolean isSelected = cat == this.selectedCategory;
            boolean isHovered = this.isPointInRect(mouseX, mouseY, sidebarX + 12, contentY, 216, 50);
            float targetAnim = isHovered ? 1.0f : (isSelected ? 0.5f : 0.0f);
            float currentAnim = this.categoryHoverAnim.get((Object)cat).floatValue();
            this.categoryHoverAnim.put(cat, Float.valueOf(currentAnim + (targetAnim - currentAnim) * delta * 0.15f));
            float anim = this.categoryHoverAnim.get((Object)cat).floatValue();
            int btnX = sidebarX + 12;
            int btnW = 216;
            Color btnBg = isSelected ? new Color((int)((float)ACCENT_PRIMARY.getRed() + (float)(BG_CARD.getRed() - ACCENT_PRIMARY.getRed()) * (1.0f - anim)), (int)((float)ACCENT_PRIMARY.getGreen() + (float)(BG_CARD.getGreen() - ACCENT_PRIMARY.getGreen()) * (1.0f - anim)), (int)((float)ACCENT_PRIMARY.getBlue() + (float)(BG_CARD.getBlue() - ACCENT_PRIMARY.getBlue()) * (1.0f - anim)), 140 + (int)(40.0f * anim)) : new Color(BG_CARD.getRed(), BG_CARD.getGreen(), BG_CARD.getBlue(), 80 + (int)(80.0f * anim));
            RenderUtils.renderRoundedQuadShader(context.method_51448(), btnBg, btnX, contentY, btnW, 50.0, 12.0, 80.0);
            if (isSelected) {
                int barAlpha = 180 + (int)(75.0 * Math.sin(this.globalTime * 3.0f));
                Color barColor = new Color(ACCENT_GLOW.getRed(), ACCENT_GLOW.getGreen(), ACCENT_GLOW.getBlue(), barAlpha);
                RenderUtils.renderRoundedQuadShader(context.method_51448(), barColor, btnX + 4, contentY + 10, 3.0, 30.0, 2.0, 50.0);
            }
            int iconX = btnX + 22;
            int iconY = contentY + 25;
            Color iconColor = isSelected ? ACCENT_GLOW : TEXT_MUTED;
            RenderUtils.renderCircle(context.method_51448(), iconColor, iconX, iconY, 7.0, 16);
            if (isSelected) {
                RenderUtils.renderCircle(context.method_51448(), new Color(255, 255, 255, 100), iconX, iconY, 4.0, 12);
            }
            int textX = iconX + 20;
            int textY = contentY + 20;
            Color textColor = isSelected ? TEXT_PRIMARY : TEXT_SECONDARY;
            TextRenderer.drawString(cat.name, context, textX, textY, textColor.getRGB());
            int moduleCount = DonutBBC.INSTANCE.getModuleManager().keyCodec(cat).size();
            String countStr = String.valueOf(moduleCount);
            int badgeW = 32;
            int badgeX = btnX + btnW - badgeW - 8;
            int badgeY = contentY + 16;
            Color badgeBg = isSelected ? new Color(BG_DEEPEST.getRed(), BG_DEEPEST.getGreen(), BG_DEEPEST.getBlue(), 150) : BG_ELEVATED;
            RenderUtils.renderRoundedQuadShader(context.method_51448(), badgeBg, badgeX, badgeY, badgeW, 20.0, 10.0, 50.0);
            TextRenderer.drawCenteredString(countStr, context, badgeX + 16, badgeY + 6, TEXT_MUTED.getRGB());
            contentY += 58;
        }
    }

    private void renderContent(class_332 context, int mouseX, int mouseY, float delta) {
        int contentX = this.guiX + 240;
        int contentY = this.guiY + 72;
        int contentW = 740 - (this.selectedModule != null ? 320 : 0);
        int contentH = 568;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), BG_CARD, contentX, contentY, contentW, contentH, 0.0, 100.0);
        this.renderSearchBar(context, contentX, contentY, contentW, mouseX, mouseY);
        int gridY = contentY + 90;
        int gridH = contentH - 90;
        this.renderModulesGrid(context, contentX, gridY, contentW, gridH, mouseX, mouseY, delta);
    }

    private void renderSearchBar(class_332 context, int x, int y, int width, int mouseX, int mouseY) {
        int searchX = x + 20;
        int searchY = y + 20;
        int searchW = width - 40;
        int searchH = 52;
        boolean hovered = this.isPointInRect(mouseX, mouseY, searchX, searchY, searchW, searchH);
        Color searchBg = this.isSearchFocused ? BG_ELEVATED : (hovered ? BG_HOVER : new Color(BG_DEEP.getRed(), BG_DEEP.getGreen(), BG_DEEP.getBlue(), 150));
        RenderUtils.renderRoundedQuadShader(context.method_51448(), searchBg, searchX, searchY, searchW, searchH, 12.0, 80.0);
        if (this.isSearchFocused) {
            int glowAlpha = 60 + (int)(40.0f * this.searchPulse);
            Color glowColor = new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), glowAlpha);
            RenderUtils.renderRoundedOutline(context, glowColor, searchX, searchY, searchX + searchW, searchY + searchH, 12.0, 12.0, 12.0, 12.0, 2.0, 80.0);
        }
        int iconX = searchX + 18;
        int iconY = searchY + 20;
        TextRenderer.drawString("\ud83d\udd0d", context, iconX, iconY, TEXT_SECONDARY.getRGB());
        String displayText = this.searchQuery.isEmpty() ? "Search modules..." : this.searchQuery;
        Color textColor = this.searchQuery.isEmpty() ? TEXT_DIM : TEXT_PRIMARY;
        int textX = iconX + 32;
        int textY = searchY + 20;
        TextRenderer.drawString(displayText, context, textX, textY, textColor.getRGB());
        if (this.isSearchFocused && System.currentTimeMillis() / 600L % 2L == 0L) {
            int cursorX = textX + TextRenderer.getWidth(this.searchQuery);
            int cursorH = 16;
            context.method_25294(cursorX, textY - 2, cursorX + 2, textY + cursorH, ACCENT_PRIMARY.getRGB());
        }
        if (!this.searchQuery.isEmpty()) {
            int clearX = searchX + searchW - 40;
            int clearY = searchY + (searchH - 28) / 2;
            boolean clearHovered = this.isPointInRect(mouseX, mouseY, clearX, clearY, 28, 28);
            Color clearBg = clearHovered ? new Color(ERROR.getRed(), ERROR.getGreen(), ERROR.getBlue(), 100) : BG_ELEVATED;
            RenderUtils.renderRoundedQuadShader(context.method_51448(), clearBg, clearX, clearY, 28.0, 28.0, 8.0, 50.0);
            TextRenderer.drawCenteredString("\u2715", context, clearX + 14, clearY + 8, TEXT_SECONDARY.getRGB());
        }
    }

    private void renderModulesGrid(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, float delta) {
        List<Module> modules = DonutBBC.INSTANCE.getModuleManager().keyCodec(this.selectedCategory);
        if (!this.searchQuery.isEmpty()) {
            modules = modules.stream().filter(m -> m.getName().toString().toLowerCase().contains(this.searchQuery.toLowerCase())).collect(Collectors.toList());
        }
        int cardW = 280;
        int cardH = 110;
        int gap = 16;
        int cols = Math.max(1, (width - 40) / (cardW + gap));
        int startX = x + 20;
        int startY = y + 20;
        double scale = class_310.method_1551().method_22683().method_4495();
        context.method_44379((int)((double)x / scale), (int)((double)y / scale), (int)((double)(x + width) / scale), (int)((double)(y + height) / scale));
        for (int i = 0; i < modules.size(); ++i) {
            Color statusColor;
            Module module = modules.get(i);
            if (!this.moduleHoverAnim.containsKey(module)) {
                this.moduleHoverAnim.put(module, Float.valueOf(0.0f));
            }
            int row = i / cols;
            int col = i % cols;
            int cardX = startX + col * (cardW + gap);
            int cardY = startY + row * (cardH + gap) - this.moduleScrollOffset * 50;
            if (cardY + cardH < y || cardY > y + height) continue;
            boolean hovered = this.isPointInRect(mouseX, mouseY, cardX, cardY, cardW, cardH);
            boolean enabled = module.isEnabled();
            boolean selected = module == this.selectedModule;
            float targetAnim = hovered ? 1.0f : 0.0f;
            float currentAnim = this.moduleHoverAnim.get(module).floatValue();
            this.moduleHoverAnim.put(module, Float.valueOf(currentAnim + (targetAnim - currentAnim) * delta * 0.15f));
            float anim = this.moduleHoverAnim.get(module).floatValue();
            int liftOffset = (int)(anim * -3.0f);
            Color cardBg = selected ? new Color(BG_ELEVATED.getRed(), BG_ELEVATED.getGreen(), BG_ELEVATED.getBlue(), 220) : new Color(BG_CARD.getRed(), BG_CARD.getGreen(), BG_CARD.getBlue(), 180 + (int)(40.0f * anim));
            RenderUtils.renderRoundedQuadShader(context.method_51448(), cardBg, cardX, cardY + liftOffset, cardW, cardH, 12.0, 80.0);
            if (enabled || selected) {
                Color borderColor = enabled ? new Color(SUCCESS.getRed(), SUCCESS.getGreen(), SUCCESS.getBlue(), 100 + (int)(60.0f * anim)) : new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), 80);
                RenderUtils.renderRoundedOutline(context, borderColor, cardX, cardY + liftOffset, cardX + cardW, cardY + liftOffset + cardH, 12.0, 12.0, 12.0, 12.0, 1.5 + (double)anim, 80.0);
            }
            int statusX = cardX + 16;
            int statusY = cardY + liftOffset + 20;
            Color color = statusColor = enabled ? SUCCESS : new Color(71, 85, 105);
            if (enabled) {
                int pulseAlpha = 20 + (int)(15.0 * Math.sin(this.globalTime * 4.0f));
                RenderUtils.renderCircle(context.method_51448(), new Color(SUCCESS.getRed(), SUCCESS.getGreen(), SUCCESS.getBlue(), pulseAlpha), statusX, statusY, 10.0, 16);
            }
            RenderUtils.renderCircle(context.method_51448(), statusColor, statusX, statusY, 6.0, 16);
            int nameX = statusX + 20;
            int nameY = cardY + liftOffset + 15;
            TextRenderer.drawString(module.getName().toString(), context, nameX, nameY, TEXT_PRIMARY.getRGB());
            Object desc = module.getDescription().toString();
            int descMaxW = cardW - 32;
            if (TextRenderer.getWidth((CharSequence)desc) > descMaxW) {
                while (TextRenderer.getWidth((String)desc + "...") > descMaxW && ((String)desc).length() > 1) {
                    desc = ((String)desc).substring(0, ((String)desc).length() - 1);
                }
                desc = (String)desc + "...";
            }
            int descY = cardY + liftOffset + 52;
            TextRenderer.drawString((CharSequence)desc, context, cardX + 16, descY, TEXT_MUTED.getRGB());
            int footerY = cardY + liftOffset + cardH - 36;
            if (!module.getSettings().isEmpty()) {
                int settingsCount;
                String settingsText = settingsCount + " setting" + ((settingsCount = module.getSettings().size()) != 1 ? "s" : "");
                TextRenderer.drawString(settingsText, context, cardX + 16, footerY + 8, TEXT_DIM.getRGB());
            }
            int switchX = cardX + cardW - 60;
            this.renderEnhancedSwitch(context, switchX, footerY, enabled, hovered || selected);
        }
        context.method_44380();
        if (modules.isEmpty()) {
            int emptyY = y + height / 2 - 40;
            TextRenderer.drawCenteredString("No modules found", context, x + width / 2, emptyY, TEXT_MUTED.getRGB());
            TextRenderer.drawCenteredString("Try a different search term", context, x + width / 2, emptyY + 20, TEXT_DIM.getRGB());
        }
    }

    private void renderEnhancedSwitch(class_332 context, int x, int y, boolean enabled, boolean highlighted) {
        int switchW = 48;
        int switchH = 26;
        Color trackColor = enabled ? new Color(SUCCESS.getRed(), SUCCESS.getGreen(), SUCCESS.getBlue(), 180) : new Color(71, 85, 105, 150);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), trackColor, x, y, switchW, switchH, 13.0, 60.0);
        if (!enabled) {
            Color innerShadow = new Color(0, 0, 0, 30);
            RenderUtils.renderRoundedQuadShader(context.method_51448(), innerShadow, x + 2, y + 2, switchW - 4, switchH - 4, 11.0, 50.0);
        }
        int knobSize = 20;
        float knobX = enabled ? (float)(x + switchW - knobSize - 3) : (float)(x + 3);
        Color knobShadow = new Color(0, 0, 0, 40);
        RenderUtils.renderCircle(context.method_51448(), knobShadow, knobX + (float)knobSize / 2.0f + 1.0f, (float)y + (float)switchH / 2.0f + 1.0f, (float)knobSize / 2.0f + 1.0f, 16);
        Color knobColor = enabled ? new Color(248, 250, 252) : new Color(203, 213, 225);
        RenderUtils.renderCircle(context.method_51448(), knobColor, knobX + (float)knobSize / 2.0f, (float)y + (float)switchH / 2.0f, (float)knobSize / 2.0f, 20);
        if (highlighted || enabled) {
            Color highlight = new Color(255, 255, 255, enabled ? 120 : 60);
            RenderUtils.renderCircle(context.method_51448(), highlight, knobX + (float)knobSize / 2.0f - 2.0f, (float)y + (float)switchH / 2.0f - 2.0f, 4.0, 12);
        }
    }

    private void renderSettingsPanel(class_332 context, int mouseX, int mouseY, float delta) {
        int panelW = 320;
        int panelX = this.guiX + 980 - panelW;
        int panelY = this.guiY + 72;
        int panelH = 568;
        int slideOffset = (int)((1.0f - this.panelTransition) * 50.0f);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), BG_DEEP, panelX + slideOffset, panelY, panelW, panelH, 0.0, 100.0);
        context.method_25294(panelX + slideOffset, panelY, panelX + slideOffset + 1, panelY + panelH, DIVIDER.getRGB());
        int headerY = panelY + 20;
        int iconX = panelX + slideOffset + 20;
        RenderUtils.renderCircle(context.method_51448(), ACCENT_PRIMARY, iconX + 6, headerY + 8, 6.0, 12);
        String moduleName = this.selectedModule.getName().toString();
        int nameX = iconX + 20;
        TextRenderer.drawString(moduleName, context, nameX, headerY + 3, TEXT_PRIMARY.getRGB());
        boolean enabled = this.selectedModule.isEnabled();
        String statusText = enabled ? "ENABLED" : "DISABLED";
        Color statusColor = enabled ? SUCCESS : TEXT_MUTED;
        int statusY = headerY + 22;
        TextRenderer.drawString(statusText, context, nameX, statusY, statusColor.getRGB());
        int closeX = panelX + slideOffset + panelW - 20 - 32;
        boolean closeHovered = this.isPointInRect(mouseX, mouseY, closeX, headerY, 32, 32);
        Color closeBg = closeHovered ? new Color(ERROR.getRed(), ERROR.getGreen(), ERROR.getBlue(), 100) : BG_ELEVATED;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), closeBg, closeX, headerY, 32.0, 32.0, 10.0, 60.0);
        TextRenderer.drawCenteredString("\u2715", context, closeX + 16, headerY + 10, TEXT_SECONDARY.getRGB());
        int settingsStartY = headerY + 70;
        int availableHeight = panelH - (settingsStartY - panelY) - 20;
        double scale = class_310.method_1551().method_22683().method_4495();
        context.method_44379((int)((double)(panelX + slideOffset) / scale), (int)((double)settingsStartY / scale), (int)((double)(panelX + slideOffset + panelW) / scale), (int)((double)(settingsStartY + availableHeight) / scale));
        int settingY = settingsStartY - this.settingsScrollOffset;
        List<Setting> settings = this.selectedModule.getSettings();
        if (settings.isEmpty()) {
            int emptyY = settingsStartY + availableHeight / 2 - 20;
            TextRenderer.drawCenteredString("No settings available", context, panelX + slideOffset + panelW / 2, emptyY, TEXT_MUTED.getRGB());
        } else {
            for (Setting setting : settings) {
                int itemHeight = this.getSettingHeight(setting);
                if (settingY + itemHeight >= settingsStartY && settingY <= settingsStartY + availableHeight) {
                    this.renderSettingItem(context, panelX + slideOffset + 20, settingY, panelW - 40, setting, mouseX, mouseY);
                }
                settingY += itemHeight + 16;
            }
        }
        context.method_44380();
        int totalHeight = this.getTotalSettingsHeight(settings);
        if (totalHeight > availableHeight) {
            this.renderScrollbar(context, panelX + slideOffset, settingsStartY, panelW, availableHeight, totalHeight, this.settingsScrollOffset);
        }
    }

    private void renderScrollbar(class_332 context, int panelX, int startY, int panelW, int viewHeight, int contentHeight, int scrollOffset) {
        int scrollbarW = 5;
        int scrollbarX = panelX + panelW - 10 - scrollbarW;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), new Color(BG_ELEVATED.getRed(), BG_ELEVATED.getGreen(), BG_ELEVATED.getBlue(), 100), scrollbarX, startY, scrollbarW, viewHeight, 3.0, 50.0);
        float scrollRatio = (float)viewHeight / (float)contentHeight;
        int thumbHeight = Math.max(30, (int)((float)viewHeight * scrollRatio));
        float scrollProgress = (float)scrollOffset / (float)(contentHeight - viewHeight);
        int thumbY = startY + (int)((float)(viewHeight - thumbHeight) * scrollProgress);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), ACCENT_PRIMARY, scrollbarX, thumbY, scrollbarW, thumbHeight, 3.0, 50.0);
    }

    private int getTotalSettingsHeight(List<Setting> settings) {
        int total = 0;
        for (Setting setting : settings) {
            total += this.getSettingHeight(setting) + 16;
        }
        return total;
    }

    private int getSettingHeight(Setting setting) {
        if (setting instanceof NumberSetting || setting instanceof MinMaxSetting) {
            return 70;
        }
        return setting instanceof ColorSetting ? 80 : 64;
    }

    private void renderSettingItem(class_332 context, int x, int y, int width, Setting setting, int mouseX, int mouseY) {
        int itemHeight = this.getSettingHeight(setting);
        boolean hovered = this.isPointInRect(mouseX, mouseY, x, y, width, itemHeight);
        Color itemBg = hovered ? BG_HOVER : new Color(BG_CARD.getRed(), BG_CARD.getGreen(), BG_CARD.getBlue(), 120);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), itemBg, x, y, width, itemHeight, 10.0, 70.0);
        TextRenderer.drawString(setting.getName().toString(), context, x + 14, y + 14, TEXT_SECONDARY.getRGB());
        if (setting instanceof BooleanSetting) {
            BooleanSetting bool = (BooleanSetting)setting;
            this.renderEnhancedSwitch(context, x + width - 60, y + 18, bool.getValue(), hovered);
        } else if (setting instanceof NumberSetting) {
            NumberSetting num = (NumberSetting)setting;
            this.renderNumberSetting(context, x, y, width, num, mouseX, mouseY, hovered);
        } else if (setting instanceof MinMaxSetting) {
            MinMaxSetting minMax = (MinMaxSetting)setting;
            this.renderMinMaxSetting(context, x, y, width, minMax, mouseX, mouseY, hovered);
        } else if (setting instanceof ModeSetting) {
            ModeSetting mode = (ModeSetting)setting;
            this.renderModeSetting(context, x, y, width, mode, hovered);
        } else if (setting instanceof BlocksSetting) {
            BlocksSetting blocks = (BlocksSetting)setting;
            this.renderCountSetting(context, x, y, width, blocks.size(), "block");
        } else if (setting instanceof BindSetting) {
            BindSetting bind = (BindSetting)setting;
            this.renderBindSetting(context, x, y, width, bind, hovered);
        } else if (setting instanceof StringSetting) {
            StringSetting str = (StringSetting)setting;
            this.renderStringSetting(context, x, y, width, str, hovered);
        } else if (setting instanceof ColorSetting) {
            ColorSetting color = (ColorSetting)setting;
            this.renderColorSetting(context, x, y, width, color, hovered);
        } else if (setting instanceof ItemSetting) {
            ItemSetting item = (ItemSetting)setting;
            this.renderItemSetting(context, x, y, width, item);
        } else if (setting instanceof MacroSetting) {
            MacroSetting macro = (MacroSetting)setting;
            this.renderCountSetting(context, x, y, width, macro.getCommands().size(), "command");
        } else if (setting instanceof FriendsSetting) {
            FriendsSetting friends = (FriendsSetting)setting;
            this.renderCountSetting(context, x, y, width, friends.size(), "friend");
        }
    }

    private void renderNumberSetting(class_332 context, int x, int y, int width, NumberSetting num, int mouseX, int mouseY, boolean hovered) {
        boolean thumbHovered;
        String value = this.formatNumberValue(num);
        int valueX = x + width - TextRenderer.getWidth(value) - 14;
        TextRenderer.drawString(value, context, valueX, y + 14, ACCENT_PRIMARY.getRGB());
        int sliderY = y + 42;
        int sliderX = x + 14;
        int sliderW = width - 28;
        int sliderH = 6;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), new Color(BG_ELEVATED.getRed(), BG_ELEVATED.getGreen(), BG_ELEVATED.getBlue(), 150), sliderX, sliderY, sliderW, sliderH, 3.0, 50.0);
        double progress = (num.getValue() - num.getMin()) / (num.getMax() - num.getMin());
        int progressW = (int)((double)sliderW * progress);
        Color progressColor = new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), 200);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), progressColor, sliderX, sliderY, progressW, sliderH, 3.0, 50.0);
        int thumbX = sliderX + progressW;
        int thumbY = sliderY + sliderH / 2;
        boolean bl = thumbHovered = Math.abs(mouseX - thumbX) < 10 && Math.abs(mouseY - thumbY) < 10;
        if (thumbHovered || this.isDraggingSlider) {
            RenderUtils.renderCircle(context.method_51448(), new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), 40), thumbX, thumbY, 12.0, 16);
        }
        RenderUtils.renderCircle(context.method_51448(), ACCENT_PRIMARY, thumbX, thumbY, 8.0, 16);
        RenderUtils.renderCircle(context.method_51448(), new Color(255, 255, 255, 180), thumbX, thumbY, 4.0, 12);
    }

    private void renderMinMaxSetting(class_332 context, int x, int y, int width, MinMaxSetting minMax, int mouseX, int mouseY, boolean hovered) {
        String value = this.formatMinMaxValue(minMax);
        int valueX = x + width - TextRenderer.getWidth(value) - 14;
        TextRenderer.drawString(value, context, valueX, y + 14, ACCENT_PRIMARY.getRGB());
        int sliderY = y + 42;
        int sliderX = x + 14;
        int sliderW = width - 28;
        int sliderH = 6;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), new Color(BG_ELEVATED.getRed(), BG_ELEVATED.getGreen(), BG_ELEVATED.getBlue(), 150), sliderX, sliderY, sliderW, sliderH, 3.0, 50.0);
        double minProgress = (minMax.getCurrentMin() - minMax.getMinValue()) / (minMax.getMaxValue() - minMax.getMinValue());
        double maxProgress = (minMax.getCurrentMax() - minMax.getMinValue()) / (minMax.getMaxValue() - minMax.getMinValue());
        int minX = sliderX + (int)((double)sliderW * minProgress);
        int maxX = sliderX + (int)((double)sliderW * maxProgress);
        RenderUtils.renderRoundedQuadShader(context.method_51448(), ACCENT_PRIMARY, minX, sliderY, maxX - minX, sliderH, 3.0, 50.0);
        int thumbY = sliderY + sliderH / 2;
        RenderUtils.renderCircle(context.method_51448(), ACCENT_PRIMARY, minX, thumbY, 8.0, 16);
        RenderUtils.renderCircle(context.method_51448(), ACCENT_SECONDARY, maxX, thumbY, 8.0, 16);
        RenderUtils.renderCircle(context.method_51448(), new Color(255, 255, 255, 180), minX, thumbY, 4.0, 12);
        RenderUtils.renderCircle(context.method_51448(), new Color(255, 255, 255, 180), maxX, thumbY, 4.0, 12);
    }

    private void renderModeSetting(class_332 context, int x, int y, int width, ModeSetting<?> mode, boolean hovered) {
        String modeName = mode.getValue().name();
        int btnW = Math.min(140, TextRenderer.getWidth(modeName) + 28);
        int btnX = x + width - btnW - 14;
        int btnY = y + 36;
        Color btnBg = hovered ? BG_HOVER : BG_ELEVATED;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), btnBg, btnX, btnY, btnW, 24.0, 8.0, 60.0);
        TextRenderer.drawCenteredString(modeName, context, btnX + btnW / 2, btnY + 8, ACCENT_PRIMARY.getRGB());
        TextRenderer.drawString("\u2039", context, btnX + 6, btnY + 6, TEXT_MUTED.getRGB());
        TextRenderer.drawString("\u203a", context, btnX + btnW - 14, btnY + 6, TEXT_MUTED.getRGB());
    }

    private void renderBindSetting(class_332 context, int x, int y, int width, BindSetting bind, boolean hovered) {
        Color btnBg;
        String keyName = bind.isListening() ? "Press a key..." : KeyUtils.getKey(bind.getValue()).toString();
        int btnW = Math.min(140, TextRenderer.getWidth(keyName) + 28);
        int btnX = x + width - btnW - 14;
        int btnY = y + 36;
        if (bind.isListening()) {
            int pulseAlpha = 100 + (int)(60.0 * Math.sin(this.globalTime * 5.0f));
            btnBg = new Color(ACCENT_PRIMARY.getRed(), ACCENT_PRIMARY.getGreen(), ACCENT_PRIMARY.getBlue(), pulseAlpha);
        } else {
            btnBg = hovered ? BG_HOVER : BG_ELEVATED;
        }
        RenderUtils.renderRoundedQuadShader(context.method_51448(), btnBg, btnX, btnY, btnW, 24.0, 8.0, 60.0);
        Color textColor = bind.isListening() ? TEXT_PRIMARY : ACCENT_PRIMARY;
        TextRenderer.drawCenteredString(keyName, context, btnX + btnW / 2, btnY + 8, textColor.getRGB());
    }

    private void renderStringSetting(class_332 context, int x, int y, int width, StringSetting str, boolean hovered) {
        Object value = str.getValue();
        if (((String)value).length() > 18) {
            value = ((String)value).substring(0, 15) + "...";
        }
        int btnW = Math.min(160, TextRenderer.getWidth((CharSequence)value) + 32);
        int btnX = x + width - btnW - 14;
        int btnY = y + 36;
        Color btnBg = hovered ? BG_HOVER : BG_ELEVATED;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), btnBg, btnX, btnY, btnW, 24.0, 8.0, 60.0);
        TextRenderer.drawString((CharSequence)value, context, btnX + 12, btnY + 8, TEXT_SECONDARY.getRGB());
        TextRenderer.drawString("\u270e", context, btnX + btnW - 20, btnY + 8, TEXT_MUTED.getRGB());
    }

    private void renderColorSetting(class_332 context, int x, int y, int width, ColorSetting color, boolean hovered) {
        Color colorValue = color.getValue();
        int previewSize = 32;
        int previewX = x + width - previewSize - 14;
        int previewY = y + 32;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), colorValue, previewX, previewY, previewSize, previewSize, 8.0, 60.0);
        RenderUtils.renderRoundedOutline(context, TEXT_MUTED, previewX, previewY, previewX + previewSize, previewY + previewSize, 8.0, 8.0, 8.0, 8.0, 1.5, 60.0);
        String rgb = String.format("RGB(%d,%d,%d)", colorValue.getRed(), colorValue.getGreen(), colorValue.getBlue());
        TextRenderer.drawString(rgb, context, x + 14, y + 42, TEXT_MUTED.getRGB());
    }

    private void renderItemSetting(class_332 context, int x, int y, int width, ItemSetting item) {
        class_1792 itemValue = item.getItem();
        int iconSize = 28;
        int iconX = x + width - iconSize - 16;
        int iconY = y + 32;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), BG_ELEVATED, iconX - 4, iconY - 4, iconSize + 8, iconSize + 8, 8.0, 60.0);
        if (itemValue != null && itemValue != class_1802.field_8162) {
            context.method_51427(new class_1799((class_1935)itemValue), iconX, iconY);
        } else {
            TextRenderer.drawCenteredString("?", context, iconX + iconSize / 2, iconY + 8, TEXT_MUTED.getRGB());
        }
    }

    private void renderCountSetting(class_332 context, int x, int y, int width, int count, String singular) {
        String countText = count + " " + singular + (count != 1 ? "s" : "");
        int btnW = Math.min(140, TextRenderer.getWidth(countText) + 28);
        int btnX = x + width - btnW - 14;
        int btnY = y + 36;
        RenderUtils.renderRoundedQuadShader(context.method_51448(), BG_ELEVATED, btnX, btnY, btnW, 24.0, 8.0, 60.0);
        TextRenderer.drawCenteredString(countText, context, btnX + btnW / 2, btnY + 8, ACCENT_PRIMARY.getRGB());
    }

    private String formatNumberValue(NumberSetting num) {
        double format = num.getFormat();
        double value = num.getValue();
        if (format == 0.1) {
            return String.format("%.1f", value);
        }
        if (format == 0.01) {
            return String.format("%.2f", value);
        }
        if (format == 0.001) {
            return String.format("%.3f", value);
        }
        return format >= 1.0 ? String.format("%.0f", value) : String.valueOf(value);
    }

    private String formatMinMaxValue(MinMaxSetting minMax) {
        String maxStr;
        String minStr;
        double step = minMax.getStep();
        if (step == 0.1) {
            minStr = String.format("%.1f", minMax.getCurrentMin());
            maxStr = String.format("%.1f", minMax.getCurrentMax());
        } else if (step == 0.01) {
            minStr = String.format("%.2f", minMax.getCurrentMin());
            maxStr = String.format("%.2f", minMax.getCurrentMax());
        } else if (step >= 1.0) {
            minStr = String.format("%.0f", minMax.getCurrentMin());
            maxStr = String.format("%.0f", minMax.getCurrentMax());
        } else {
            minStr = String.valueOf(minMax.getCurrentMin());
            maxStr = String.valueOf(minMax.getCurrentMax());
        }
        return minStr + " - " + maxStr;
    }

    private boolean isPointInRect(int px, int py, int x, int y, int width, int height) {
        return px >= x && px <= x + width && py >= y && py <= y + height;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.shouldUseReaperGUI()) {
            int clearY;
            int contentW;
            int searchW;
            int contentX;
            int searchX;
            int clearX;
            int closeY;
            int closeX;
            int scaledY;
            int scaledX = (int)(mouseX * class_310.method_1551().method_22683().method_4495());
            if (this.isPointInRect(scaledX, scaledY = (int)(mouseY * class_310.method_1551().method_22683().method_4495()), closeX = this.guiX + 980 - 20 - 36, closeY = this.guiY + 18, 36, 36)) {
                this.method_25419();
                return true;
            }
            if (this.selectedModule != null && this.handleSettingsInteraction(scaledX, scaledY, button)) {
                return true;
            }
            if (!this.searchQuery.isEmpty() && this.isPointInRect(scaledX, scaledY, clearX = (searchX = (contentX = this.guiX + 240) + 20) + (searchW = (contentW = 740 - (this.selectedModule != null ? 320 : 0)) - 40) - 40, clearY = this.guiY + 72 + 20 + 12, 28, 28)) {
                this.searchQuery = "";
                return true;
            }
            contentX = this.guiX + 240;
            searchX = contentX + 20;
            int searchY = this.guiY + 72 + 20;
            contentW = 740 - (this.selectedModule != null ? 320 : 0);
            int searchW2 = contentW - 40;
            if (this.isPointInRect(scaledX, scaledY, searchX, searchY, searchW2, 52)) {
                this.isSearchFocused = true;
                return true;
            }
            this.isSearchFocused = false;
            if (this.handleCategoryClick(scaledX, scaledY)) {
                return true;
            }
            if (this.handleModuleClick(scaledX, scaledY, button)) {
                return true;
            }
            if (this.isPointInRect(scaledX, scaledY, this.guiX, this.guiY, 980, 72)) {
                this.isDragging = true;
                this.dragOffsetX = scaledX - this.guiX;
                this.dragOffsetY = scaledY - this.guiY;
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
        double scaledX = mouseX * (double)((int)class_310.method_1551().method_22683().method_4495());
        double scaledY = mouseY * (double)((int)class_310.method_1551().method_22683().method_4495());
        for (CategoryWindow window : this.reaperWindows) {
            window.mouseClicked(scaledX, scaledY, button);
        }
        return super.method_25402(scaledX, scaledY, button);
    }

    private boolean handleSettingsInteraction(int mouseX, int mouseY, int button) {
        int panelX = this.guiX + 980 - 320;
        int panelW = 320;
        int panelY = this.guiY + 72;
        int panelH = 568;
        int settingsCloseX = panelX + panelW - 20 - 32;
        int settingsCloseY = panelY + 20;
        if (this.isPointInRect(mouseX, mouseY, settingsCloseX, settingsCloseY, 32, 32)) {
            this.selectedModule = null;
            this.settingsScrollOffset = 0;
            this.panelTransition = 0.0f;
            return true;
        }
        int headerY = panelY + 20;
        int settingsStartY = headerY + 70;
        int settingY = settingsStartY - this.settingsScrollOffset;
        int availableHeight = panelH - (settingsStartY - panelY) - 20;
        List<Setting> settings = this.selectedModule.getSettings();
        int settingX = panelX + 20;
        int settingW = panelW - 40;
        for (Setting setting : settings) {
            int itemHeight = this.getSettingHeight(setting);
            if (settingY + itemHeight >= settingsStartY && settingY <= settingsStartY + availableHeight && this.isPointInRect(mouseX, mouseY, settingX, settingY, settingW, itemHeight)) {
                if (setting instanceof BooleanSetting) {
                    BooleanSetting bool;
                    bool.setValue(!(bool = (BooleanSetting)setting).getValue());
                    return true;
                }
                if (setting instanceof NumberSetting) {
                    NumberSetting num = (NumberSetting)setting;
                    sliderY = settingY + 42;
                    sliderX = settingX + 14;
                    sliderW = settingW - 28;
                    if (mouseY >= sliderY - 8 && mouseY <= sliderY + 14) {
                        this.isDraggingSlider = true;
                        this.draggedSetting = setting;
                        this.updateSliderValue(num, mouseX, sliderX, sliderW);
                        return true;
                    }
                } else if (setting instanceof MinMaxSetting) {
                    MinMaxSetting minMax = (MinMaxSetting)setting;
                    sliderY = settingY + 42;
                    sliderX = settingX + 14;
                    sliderW = settingW - 28;
                    if (mouseY >= sliderY - 8 && mouseY <= sliderY + 14) {
                        double minProgress = (minMax.getCurrentMin() - minMax.getMinValue()) / (minMax.getMaxValue() - minMax.getMinValue());
                        double maxProgress = (minMax.getCurrentMax() - minMax.getMinValue()) / (minMax.getMaxValue() - minMax.getMinValue());
                        int minX = sliderX + (int)((double)sliderW * minProgress);
                        int maxX = sliderX + (int)((double)sliderW * maxProgress);
                        this.draggedIsMin = Math.abs(mouseX - minX) < Math.abs(mouseX - maxX);
                        this.isDraggingSlider = true;
                        this.draggedSetting = setting;
                        this.updateMinMaxSlider(minMax, mouseX, sliderX, sliderW, this.draggedIsMin);
                        return true;
                    }
                } else {
                    if (setting instanceof ModeSetting) {
                        ModeSetting mode = (ModeSetting)setting;
                        if (button == 0) {
                            mode.cycleUp();
                        } else if (button == 1) {
                            mode.cycleDown();
                        }
                        return true;
                    }
                    if (setting instanceof BindSetting) {
                        BindSetting bind = (BindSetting)setting;
                        if (button == 0) {
                            bind.setListening(!bind.isListening());
                        } else if (button == 1 && bind.isListening()) {
                            bind.setValue(-1);
                            bind.setListening(false);
                        }
                        return true;
                    }
                    if (setting instanceof StringSetting) {
                        class_310.method_1551().method_1507((class_437)new StringBox(this.createDummyTextBox(setting), (StringSetting)setting));
                        return true;
                    }
                    if (setting instanceof ItemSetting) {
                        class_310.method_1551().method_1507((class_437)new ItemFilter(this.createDummyItemBox(setting), (ItemSetting)setting));
                        return true;
                    }
                    if (setting instanceof MacroSetting) {
                        class_310.method_1551().method_1507((class_437)new MacroFilter(this.createDummyMacroBox(setting), (MacroSetting)setting));
                        return true;
                    }
                    if (setting instanceof FriendsSetting) {
                        class_310.method_1551().method_1507((class_437)new FriendsFilter(this.createDummyFriendsBox(setting), (FriendsSetting)setting));
                        return true;
                    }
                    if (setting instanceof BlocksSetting) {
                        class_310.method_1551().method_1507((class_437)new BlocksFilter(this.createDummyBlocksBox(setting), (BlocksSetting)setting));
                        return true;
                    }
                    if (setting instanceof ColorSetting) {
                        ColorSetting color = (ColorSetting)setting;
                        Color current = color.getValue();
                        Color newColor = current.equals(Color.WHITE) ? Color.RED : (current.equals(Color.RED) ? new Color(255, 128, 0) : (current.getRed() == 255 && current.getGreen() == 128 ? Color.YELLOW : (current.equals(Color.YELLOW) ? Color.GREEN : (current.equals(Color.GREEN) ? Color.CYAN : (current.equals(Color.CYAN) ? Color.BLUE : (current.equals(Color.BLUE) ? new Color(128, 0, 255) : (current.getRed() == 128 && current.getBlue() == 255 ? Color.MAGENTA : (current.equals(Color.MAGENTA) ? new Color(255, 0, 128) : Color.WHITE))))))));
                        color.setValue(newColor);
                        return true;
                    }
                }
            }
            settingY += itemHeight + 16;
        }
        return false;
    }

    private boolean handleCategoryClick(int mouseX, int mouseY) {
        Category[] categories;
        int sidebarX = this.guiX;
        int categoryY = this.guiY + 72 + 20 + 32;
        for (Category cat : categories = Category.values()) {
            int btnX = sidebarX + 12;
            int btnW = 216;
            if (this.isPointInRect(mouseX, mouseY, btnX, categoryY, btnW, 50)) {
                if (this.selectedCategory != cat) {
                    this.selectedCategory = cat;
                    this.moduleScrollOffset = 0;
                }
                return true;
            }
            categoryY += 58;
        }
        return false;
    }

    private boolean handleModuleClick(int mouseX, int mouseY, int button) {
        boolean lala = skid.gypsyy.module.modules.client.DonutBBC.OpenGui();
        List<Module> modules = DonutBBC.INSTANCE.getModuleManager().keyCodec(this.selectedCategory);
        if (!this.searchQuery.isEmpty()) {
            modules = modules.stream().filter(m -> m.getName().toString().toLowerCase().contains(this.searchQuery.toLowerCase())).collect(Collectors.toList());
        }
        int contentX = this.guiX + 240;
        int contentY = this.guiY + 72 + 90;
        int contentW = 740 - (this.selectedModule != null ? 320 : 0);
        int cardW = 280;
        int cardH = 110;
        int gap = 16;
        int cols = Math.max(1, (contentW - 40) / (cardW + gap));
        int startX = contentX + 20;
        int startY = contentY + 20;
        for (int i = 0; i < modules.size(); ++i) {
            Module module = modules.get(i);
            int col = i % cols;
            int cardX = startX + col * (cardW + gap);
            int row = i / cols;
            int cardY = startY + row * (cardH + gap) - this.moduleScrollOffset * 50;
            if (!this.isPointInRect(mouseX, mouseY, cardX, cardY, cardW, cardH)) continue;
            int switchX = cardX + cardW - 60;
            int switchY = cardY + cardH - 36;
            if (this.isPointInRect(mouseX, mouseY, switchX, switchY, 48, 26)) {
                module.toggle();
                return true;
            }
            if (button == 0) {
                module.toggle();
            } else if (button == 1) {
                this.selectedModule = module;
                this.settingsScrollOffset = 0;
                this.panelTransition = 0.0f;
            }
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.shouldUseReaperGUI()) {
            int scaledX = (int)(mouseX * class_310.method_1551().method_22683().method_4495());
            int scaledY = (int)(mouseY * class_310.method_1551().method_22683().method_4495());
            if (this.isDragging) {
                this.guiX = scaledX - this.dragOffsetX;
                this.guiY = scaledY - this.dragOffsetY;
                return true;
            }
            if (this.isDraggingSlider && this.draggedSetting != null && this.selectedModule != null) {
                int panelX = this.guiX + 980 - 320;
                int panelW = 320;
                int settingX = panelX + 20;
                int settingW = panelW - 40;
                int sliderX = settingX + 14;
                int sliderW = settingW - 28;
                if (this.draggedSetting instanceof NumberSetting) {
                    this.updateSliderValue((NumberSetting)this.draggedSetting, scaledX, sliderX, sliderW);
                    return true;
                }
                if (this.draggedSetting instanceof MinMaxSetting) {
                    this.updateMinMaxSlider((MinMaxSetting)this.draggedSetting, scaledX, sliderX, sliderW, this.draggedIsMin);
                    return true;
                }
            }
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        double scaledXx = mouseX * (double)((int)class_310.method_1551().method_22683().method_4495());
        double scaledY = mouseY * (double)((int)class_310.method_1551().method_22683().method_4495());
        for (CategoryWindow window : this.reaperWindows) {
            window.mouseDragged(scaledXx, scaledY, button, deltaX, deltaY);
        }
        return super.method_25403(scaledXx, scaledY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.shouldUseReaperGUI()) {
            this.isDragging = false;
            this.isDraggingSlider = false;
            this.draggedSetting = null;
            return super.method_25406(mouseX, mouseY, button);
        }
        double scaledX = mouseX * (double)((int)class_310.method_1551().method_22683().method_4495());
        double scaledY = mouseY * (double)((int)class_310.method_1551().method_22683().method_4495());
        for (CategoryWindow window : this.reaperWindows) {
            window.mouseReleased(scaledX, scaledY, button);
        }
        return super.method_25406(scaledX, scaledY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.shouldUseReaperGUI()) {
            int panelH;
            int panelW;
            int panelY;
            int panelX;
            int scaledX = (int)(mouseX * class_310.method_1551().method_22683().method_4495());
            int scaledY = (int)(mouseY * class_310.method_1551().method_22683().method_4495());
            if (this.selectedModule != null && this.isPointInRect(scaledX, scaledY, panelX = this.guiX + 980 - 320, panelY = this.guiY + 72, panelW = 320, panelH = 568)) {
                List<Setting> settings = this.selectedModule.getSettings();
                int totalHeight = this.getTotalSettingsHeight(settings);
                int headerHeight = 90;
                int availableHeight = panelH - headerHeight - 20;
                int maxScroll = Math.max(0, totalHeight - availableHeight);
                this.settingsScrollOffset = Math.max(0, Math.min(maxScroll, this.settingsScrollOffset - (int)(verticalAmount * 25.0)));
                return true;
            }
            this.moduleScrollOffset = Math.max(0, this.moduleScrollOffset - (int)verticalAmount);
            return true;
        }
        double scaledY = mouseY * class_310.method_1551().method_22683().method_4495();
        for (CategoryWindow window : this.reaperWindows) {
            window.mouseScrolled(mouseX, scaledY, horizontalAmount, verticalAmount);
        }
        return super.method_25401(mouseX, scaledY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.shouldUseReaperGUI()) {
            for (CategoryWindow window : this.reaperWindows) {
                window.keyPressed(keyCode, scanCode, modifiers);
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.selectedModule != null) {
            for (Setting setting : this.selectedModule.getSettings()) {
                BindSetting bind;
                if (!(setting instanceof BindSetting) || !(bind = (BindSetting)setting).isListening()) continue;
                if (keyCode == 256) {
                    bind.setListening(false);
                } else if (keyCode == 259) {
                    bind.setValue(-1);
                    bind.setListening(false);
                } else {
                    bind.setValue(keyCode);
                    bind.setListening(false);
                }
                return true;
            }
        }
        if (this.isSearchFocused) {
            if (keyCode == 259 && !this.searchQuery.isEmpty()) {
                this.searchQuery = this.searchQuery.substring(0, this.searchQuery.length() - 1);
                return true;
            }
            if (keyCode == 256) {
                this.isSearchFocused = false;
                return true;
            }
            if (keyCode == 257) {
                this.isSearchFocused = false;
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.isSearchFocused && !Character.isISOControl(chr)) {
            this.searchQuery = this.searchQuery + chr;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    private void updateSliderValue(NumberSetting setting, int mouseX, int sliderX, int sliderW) {
        double progress = Math.max(0.0, Math.min(1.0, (double)(mouseX - sliderX) / (double)sliderW));
        double newValue = setting.getMin() + progress * (setting.getMax() - setting.getMin());
        double format = setting.getFormat();
        newValue = (double)Math.round(newValue / format) * format;
        setting.setValue(newValue);
    }

    private void updateMinMaxSlider(MinMaxSetting setting, int mouseX, int sliderX, int sliderW, boolean isMin) {
        double progress = Math.max(0.0, Math.min(1.0, (double)(mouseX - sliderX) / (double)sliderW));
        double newValue = setting.getMinValue() + progress * (setting.getMaxValue() - setting.getMinValue());
        double step = setting.getStep();
        newValue = (double)Math.round(newValue / step) * step;
        if (isMin) {
            setting.setCurrentMin(Math.min(newValue, setting.getCurrentMax()));
        } else {
            setting.setCurrentMax(Math.max(newValue, setting.getCurrentMin()));
        }
    }

    private TextBox createDummyTextBox(Setting setting) {
        return new TextBox(this, null, setting, 0){

            @Override
            public int parentX() {
                return 0;
            }

            @Override
            public int parentY() {
                return 0;
            }

            @Override
            public int parentWidth() {
                return 0;
            }

            @Override
            public int parentHeight() {
                return 0;
            }

            @Override
            public int parentOffset() {
                return 0;
            }
        };
    }

    private ItemBox createDummyItemBox(Setting setting) {
        return new ItemBox(this, null, setting, 0){

            @Override
            public int parentX() {
                return 0;
            }

            @Override
            public int parentY() {
                return 0;
            }

            @Override
            public int parentWidth() {
                return 0;
            }

            @Override
            public int parentHeight() {
                return 0;
            }

            @Override
            public int parentOffset() {
                return 0;
            }
        };
    }

    private MacroBox createDummyMacroBox(Setting setting) {
        return new MacroBox(this, null, setting, 0){

            @Override
            public int parentX() {
                return 0;
            }

            @Override
            public int parentY() {
                return 0;
            }

            @Override
            public int parentWidth() {
                return 0;
            }

            @Override
            public int parentHeight() {
                return 0;
            }

            @Override
            public int parentOffset() {
                return 0;
            }
        };
    }

    private FriendsBox createDummyFriendsBox(Setting setting) {
        return new FriendsBox(this, null, setting, 0){

            @Override
            public int parentX() {
                return 0;
            }

            @Override
            public int parentY() {
                return 0;
            }

            @Override
            public int parentWidth() {
                return 0;
            }

            @Override
            public int parentHeight() {
                return 0;
            }

            @Override
            public int parentOffset() {
                return 0;
            }
        };
    }

    private BlocksBox createDummyBlocksBox(Setting setting) {
        return new BlocksBox(this, null, setting, 0){

            @Override
            public int parentX() {
                return 0;
            }

            @Override
            public int parentY() {
                return 0;
            }

            @Override
            public int parentWidth() {
                return 0;
            }

            @Override
            public int parentHeight() {
                return 0;
            }

            @Override
            public int parentOffset() {
                return 0;
            }
        };
    }

    public void method_25419() {
        if (this.shouldUseReaperGUI()) {
            DonutBBC.INSTANCE.getModuleManager().getModuleByClass(skid.gypsyy.module.modules.client.DonutBBC.class).setEnabled(false);
        } else {
            DonutBBC.INSTANCE.getModuleManager().getModuleByClass(skid.gypsyy.module.modules.client.DonutBBC.class).setEnabled(false);
        }
        this.onGuiClose();
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public void onGuiClose() {
        this.selectedModule = null;
        this.searchQuery = "";
        this.isSearchFocused = false;
        this.moduleScrollOffset = 0;
        this.settingsScrollOffset = 0;
        this.isDragging = false;
        this.isDraggingSlider = false;
        this.draggedSetting = null;
        this.panelTransition = 0.0f;
        this.globalTime = 0.0f;
        this.categoryHoverAnim.clear();
        this.moduleHoverAnim.clear();
        for (Category cat : Category.values()) {
            this.categoryHoverAnim.put(cat, Float.valueOf(0.0f));
        }
        if (this.shouldUseReaperGUI()) {
            class_310.method_1551().method_29970(DonutBBC.INSTANCE.screen);
            this.currentColor = null;
            for (CategoryWindow window : this.reaperWindows) {
                window.onGuiClose();
            }
        }
    }
}

