/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.gui.components;

import java.awt.Color;
import net.minecraft.class_332;
import net.minecraft.class_437;
import skid.gypsyy.gui.Component;
import skid.gypsyy.gui.components.BlocksFilter;
import skid.gypsyy.gui.components.ModuleButton;
import skid.gypsyy.module.setting.BlocksSetting;
import skid.gypsyy.module.setting.Setting;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.MathUtil;
import skid.gypsyy.utils.TextRenderer;
import skid.gypsyy.utils.Utils;

public class BlocksBox
extends Component {
    private final BlocksSetting setting;
    private float hoverAnimation = 0.0f;
    private Color currentColor;
    private final Color TEXT_COLOR = new Color(230, 230, 230);
    private final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private final Color ITEM_BG = new Color(30, 30, 35);
    private final Color ITEM_BORDER = new Color(60, 60, 65);
    private final float CORNER_RADIUS = 4.0f;
    private final float HOVER_ANIMATION_SPEED = 0.25f;

    public BlocksBox(ModuleButton moduleButton, Setting setting, int n) {
        super(moduleButton, setting, n);
        this.setting = (BlocksSetting)setting;
    }

    @Override
    public void onUpdate() {
        Color mainColor = Utils.getMainColor(255, this.parent.settings.indexOf(this));
        this.currentColor = this.currentColor == null ? new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), 0) : new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), this.currentColor.getAlpha());
        if (this.currentColor.getAlpha() != 255) {
            this.currentColor = ColorUtil.keyCodec(0.05f, 255, this.currentColor);
        }
        super.onUpdate();
    }

    @Override
    public void render(class_332 drawContext, int n, int n2, float n3) {
        super.render(drawContext, n, n2, n3);
        this.updateAnimations(n, n2, n3);
        if (!this.parent.parent.dragging) {
            drawContext.method_25294(this.parentX(), this.parentY() + this.parentOffset() + this.offset, this.parentX() + this.parentWidth(), this.parentY() + this.parentOffset() + this.offset + this.parentHeight(), new Color(this.HOVER_COLOR.getRed(), this.HOVER_COLOR.getGreen(), this.HOVER_COLOR.getBlue(), (int)((float)this.HOVER_COLOR.getAlpha() * this.hoverAnimation)).getRGB());
        }
        int n4 = this.parentX() + 5;
        int n5 = this.parentY() + this.parentOffset() + this.offset + this.parentHeight() / 2;
        String displayText = String.valueOf(this.setting.getName()) + ": " + this.setting.size() + " block" + (this.setting.size() != 1 ? "s" : "");
        TextRenderer.drawString(displayText, drawContext, n4, n5 - 4, this.TEXT_COLOR.getRGB());
    }

    private void updateAnimations(int n, int n2, float n3) {
        float n4 = this.isHovered(n, n2) && !this.parent.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, n4, 0.25, n3 * 0.05f);
    }

    @Override
    public void mouseClicked(double n, double n2, int n3) {
        if (this.isHovered(n, n2) && n3 == 0) {
            this.mc.method_1507((class_437)new BlocksFilter(this, this.setting));
        }
        super.mouseClicked(n, n2, n3);
    }

    @Override
    public void onGuiClose() {
        this.currentColor = null;
        this.hoverAnimation = 0.0f;
        super.onGuiClose();
    }
}

