/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.gui.components;

import java.awt.Color;
import net.minecraft.class_332;
import net.minecraft.class_437;
import skid.gypsyy.gui.Component;
import skid.gypsyy.gui.components.FriendsFilter;
import skid.gypsyy.gui.components.ModuleButton;
import skid.gypsyy.module.setting.FriendsSetting;
import skid.gypsyy.module.setting.Setting;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.MathUtil;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.TextRenderer;
import skid.gypsyy.utils.Utils;

public class FriendsBox
extends Component {
    private final FriendsSetting setting;
    private float hoverAnimation = 0.0f;
    private Color currentColor;
    private final Color TEXT_COLOR = new Color(230, 230, 230);
    private final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private final Color COUNT_BG = new Color(50, 50, 60, 100);
    private final float CORNER_RADIUS = 4.0f;
    private final float HOVER_ANIMATION_SPEED = 0.25f;

    public FriendsBox(ModuleButton moduleButton, Setting setting, int n) {
        super(moduleButton, setting, n);
        this.setting = (FriendsSetting)setting;
    }

    @Override
    public void onUpdate() {
        Color mainColor = Utils.getMainColor(255, this.parent.settings.indexOf(this));
        this.currentColor = this.currentColor == null ? new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), 0) : new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), this.currentColor.getAlpha());
        if (this.currentColor.getAlpha() != 255) {
            this.currentColor = ColorUtil.keyCodec(0.05f, 255, this.currentColor);
        }
        super.onUpdate();
    }

    @Override
    public void render(class_332 drawContext, int n, int n2, float n3) {
        super.render(drawContext, n, n2, n3);
        this.updateAnimations(n, n2, n3);
        if (!this.parent.parent.dragging) {
            drawContext.method_25294(this.parentX(), this.parentY() + this.parentOffset() + this.offset, this.parentX() + this.parentWidth(), this.parentY() + this.parentOffset() + this.offset + this.parentHeight(), new Color(this.HOVER_COLOR.getRed(), this.HOVER_COLOR.getGreen(), this.HOVER_COLOR.getBlue(), (int)((float)this.HOVER_COLOR.getAlpha() * this.hoverAnimation)).getRGB());
        }
        int textX = this.parentX() + 5;
        int textY = this.parentY() + this.parentOffset() + this.offset + this.parentHeight() / 2 - 8;
        TextRenderer.drawString(String.valueOf(this.setting.getName()), drawContext, textX, textY, this.TEXT_COLOR.getRGB());
        int friendCount = this.setting.size();
        String countText = String.valueOf(friendCount);
        int badgeWidth = Math.max(24, TextRenderer.getWidth(countText) + 12);
        int badgeX = this.parentX() + this.parentWidth() - badgeWidth - 8;
        int badgeY = this.parentY() + this.parentOffset() + this.offset + (this.parentHeight() - 18) / 2;
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.COUNT_BG, badgeX, badgeY, badgeX + badgeWidth, badgeY + 18, 9.0, 9.0, 9.0, 9.0, 50.0);
        TextRenderer.drawCenteredString(countText, drawContext, badgeX + badgeWidth / 2, badgeY + 5, Utils.getMainColor(255, this.parent.settings.indexOf(this)).getRGB());
    }

    private void updateAnimations(int n, int n2, float n3) {
        float target = this.isHovered(n, n2) && !this.parent.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, target, 0.25, n3 * 0.05f);
    }

    @Override
    public void mouseClicked(double n, double n2, int n3) {
        if (this.isHovered(n, n2) && n3 == 0) {
            this.mc.method_1507((class_437)new FriendsFilter(this, this.setting));
        }
        super.mouseClicked(n, n2, n3);
    }

    @Override
    public void onGuiClose() {
        this.currentColor = null;
        this.hoverAnimation = 0.0f;
        super.onGuiClose();
    }
}

