/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.gui.components;

import java.awt.Color;
import net.minecraft.class_332;
import skid.gypsyy.gui.Component;
import skid.gypsyy.gui.components.ModuleButton;
import skid.gypsyy.module.setting.ModeSetting;
import skid.gypsyy.module.setting.Setting;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.MathUtil;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.TextRenderer;
import skid.gypsyy.utils.Utils;

public final class ModeBox
extends Component {
    private final ModeSetting<?> setting;
    private float hoverAnimation = 0.0f;
    private float selectAnimation = 0.0f;
    private float previousSelectAnimation = 0.0f;
    private boolean wasClicked = false;
    public Color currentColor;
    private final Color TEXT_COLOR = new Color(230, 230, 230);
    private final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private final Color SELECTOR_BG = new Color(40, 40, 45);
    private final float SELECTOR_HEIGHT = 4.0f;
    private final float SELECTOR_RADIUS = 2.0f;
    private final float HOVER_ANIMATION_SPEED = 0.25f;
    private final float SELECT_ANIMATION_SPEED = 0.15f;

    public ModeBox(ModuleButton moduleButton, Setting setting, int n) {
        super(moduleButton, setting, n);
        this.setting = (ModeSetting)setting;
    }

    @Override
    public void onUpdate() {
        Color mainColor = Utils.getMainColor(255, this.parent.settings.indexOf(this));
        this.currentColor = this.currentColor == null ? new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), 0) : new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), this.currentColor.getAlpha());
        if (this.currentColor.getAlpha() != 255) {
            this.currentColor = ColorUtil.keyCodec(0.05f, 255, this.currentColor);
        }
        super.onUpdate();
    }

    @Override
    public void render(class_332 drawContext, int n, int n2, float n3) {
        super.render(drawContext, n, n2, n3);
        this.updateAnimations(n, n2, n3);
        int index = this.setting.getPossibleValues().indexOf(this.setting.getValue());
        int size = this.setting.getPossibleValues().size();
        this.parentWidth();
        this.parentX();
        if (!this.parent.parent.dragging) {
            drawContext.method_25294(this.parentX(), this.parentY() + this.parentOffset() + this.offset, this.parentX() + this.parentWidth(), this.parentY() + this.parentOffset() + this.offset + this.parentHeight(), new Color(this.HOVER_COLOR.getRed(), this.HOVER_COLOR.getGreen(), this.HOVER_COLOR.getBlue(), (int)((float)this.HOVER_COLOR.getAlpha() * this.hoverAnimation)).getRGB());
        }
        TextRenderer.drawString(String.valueOf(this.setting.getName()), drawContext, this.parentX() + 5, this.parentY() + this.parentOffset() + this.offset + 9, this.TEXT_COLOR.getRGB());
        TextRenderer.drawString(this.setting.getValue().name(), drawContext, this.parentX() + TextRenderer.getWidth(String.valueOf(this.setting.getName()) + ": ") + 8, this.parentY() + this.parentOffset() + this.offset + 9, this.currentColor.getRGB());
        int n4 = this.parentY() + this.offset + this.parentOffset() + 25;
        int n5 = this.parentX() + 5;
        int n6 = this.parentWidth() - 10;
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.SELECTOR_BG, n5, n4, n5 + n6, (float)n4 + 4.0f, 2.0, 2.0, 2.0, 2.0, 50.0);
        int n7 = index - 1;
        float n8 = n7;
        if ((float)n7 < 0.0f) {
            n8 = size - 1;
        }
        int n9 = index + 1;
        float n10 = n9;
        if (n9 >= size) {
            n10 = 0.0f;
        }
        int n11 = n6 / size;
        float n12 = this.previousSelectAnimation > 0.01f ? (float)MathUtil.linearInterpolate((float)n5 + n8 * (float)n11, (float)n5 + (float)index * (float)n11, 1.0f - this.previousSelectAnimation) : (this.selectAnimation > 0.01f ? (float)MathUtil.linearInterpolate((float)n5 + (float)index * (float)n11, (float)n5 + n10 * (float)n11, this.selectAnimation) : (float)n5 + (float)index * (float)n11);
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.currentColor, n12, n4, n12 + (float)n11, (float)n4 + 4.0f, 2.0, 2.0, 2.0, 2.0, 50.0);
        int n13 = this.parentY() + this.parentOffset() + this.offset + 9;
        int parentX = this.parentX();
        int parentX2 = this.parentX();
        int parentWidth = this.parentWidth();
        TextRenderer.drawString("\u25c4", drawContext, parentX + this.parentWidth() - 25, n13, this.TEXT_COLOR.getRGB());
        TextRenderer.drawString("\u25ba", drawContext, parentX2 + parentWidth - 12, n13, this.TEXT_COLOR.getRGB());
        if (this.wasClicked) {
            this.wasClicked = false;
            this.previousSelectAnimation = 0.0f;
            this.selectAnimation = 0.01f;
        }
    }

    private void updateAnimations(int n, int n2, float n3) {
        float n4 = n3 * 0.05f;
        float n5 = this.isHovered(n, n2) && !this.parent.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, n5, 0.25, n4);
        if (this.selectAnimation > 0.01f) {
            this.selectAnimation = (float)MathUtil.exponentialInterpolate(this.selectAnimation, 0.0, 0.15f, n4);
            if (this.selectAnimation < 0.01f) {
                this.previousSelectAnimation = 0.99f;
            }
        }
        if (this.previousSelectAnimation > 0.01f) {
            this.previousSelectAnimation = (float)MathUtil.exponentialInterpolate(this.previousSelectAnimation, 0.0, 0.15f, n4);
        }
    }

    @Override
    public void keyPressed(int n, int n2, int n3) {
        if (this.mouseOver && this.parent.extended) {
            if (n == 259) {
                this.setting.setModeIndex(this.setting.getOriginalValue());
            } else if (n == 262) {
                this.cycleModeForward();
            } else if (n == 263) {
                this.cycleModeBackward();
            }
        }
        super.keyPressed(n, n2, n3);
    }

    private void cycleModeForward() {
        this.setting.cycleUp();
        this.wasClicked = true;
    }

    private void cycleModeBackward() {
        this.setting.cycleDown();
        this.wasClicked = true;
    }

    @Override
    public void mouseClicked(double n, double n2, int n3) {
        if (this.isHovered(n, n2)) {
            if (n3 == 0) {
                this.cycleModeForward();
            } else if (n3 == 1) {
                this.cycleModeBackward();
            } else if (n3 == 2) {
                this.setting.setModeIndex(this.setting.getOriginalValue());
            }
        }
        super.mouseClicked(n, n2, n3);
    }

    @Override
    public void onGuiClose() {
        this.currentColor = null;
        this.hoverAnimation = 0.0f;
        this.selectAnimation = 0.0f;
        this.previousSelectAnimation = 0.0f;
        super.onGuiClose();
    }
}

