/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import skid.gypsyy.DonutBBC;
import skid.gypsyy.gui.CategoryWindow;
import skid.gypsyy.gui.Component;
import skid.gypsyy.gui.components.BlocksBox;
import skid.gypsyy.gui.components.Checkbox;
import skid.gypsyy.gui.components.FriendsBox;
import skid.gypsyy.gui.components.ItemBox;
import skid.gypsyy.gui.components.Keybind;
import skid.gypsyy.gui.components.MacroBox;
import skid.gypsyy.gui.components.ModeBox;
import skid.gypsyy.gui.components.NumberBox;
import skid.gypsyy.gui.components.Slider;
import skid.gypsyy.gui.components.TextBox;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BindSetting;
import skid.gypsyy.module.setting.BlocksSetting;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.FriendsSetting;
import skid.gypsyy.module.setting.ItemSetting;
import skid.gypsyy.module.setting.MacroSetting;
import skid.gypsyy.module.setting.MinMaxSetting;
import skid.gypsyy.module.setting.ModeSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.module.setting.Setting;
import skid.gypsyy.module.setting.StringSetting;
import skid.gypsyy.utils.Animation;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.MathUtil;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.TextRenderer;
import skid.gypsyy.utils.Utils;

public final class ModuleButton {
    public List<Component> settings = new ArrayList<Component>();
    public CategoryWindow parent;
    public Module module;
    public int offset;
    public boolean extended;
    public int settingOffset;
    public Color currentColor;
    public Color currentAlpha;
    public Animation animation = new Animation(0.0);
    private final float CORNER_RADIUS = 6.0f;
    private final Color ACCENT_COLOR = new Color(255, 0, 102);
    private final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private final Color ENABLED_COLOR = new Color(255, 0, 102);
    private final Color DISABLED_COLOR = new Color(180, 180, 180);
    private final Color DESCRIPTION_BG = new Color(40, 40, 40, 200);
    private float hoverAnimation = 0.0f;
    private float enabledAnimation = 0.0f;
    private final float expandAnimation;

    public ModuleButton(CategoryWindow parent, Module module, int offset) {
        this.expandAnimation = 0.0f;
        this.parent = parent;
        this.module = module;
        this.offset = offset;
        this.extended = false;
        this.settingOffset = parent.getHeight();
        for (Setting next : module.getSettings()) {
            if (next instanceof BooleanSetting) {
                this.settings.add(new Checkbox(this, next, this.settingOffset));
            } else if (next instanceof NumberSetting) {
                this.settings.add(new NumberBox(this, next, this.settingOffset));
            } else if (next instanceof ModeSetting) {
                this.settings.add(new ModeBox(this, next, this.settingOffset));
            } else if (next instanceof BindSetting) {
                this.settings.add(new Keybind(this, next, this.settingOffset));
            } else if (next instanceof StringSetting) {
                this.settings.add(new TextBox(this, next, this.settingOffset));
            } else if (next instanceof MinMaxSetting) {
                this.settings.add(new Slider(this, next, this.settingOffset));
            } else if (next instanceof ItemSetting) {
                this.settings.add(new ItemBox(this, next, this.settingOffset));
            } else if (next instanceof BlocksSetting) {
                this.settings.add(new BlocksBox(this, next, this.settingOffset));
            } else if (next instanceof FriendsSetting) {
                this.settings.add(new FriendsBox(this, next, this.settingOffset));
            } else if (next instanceof MacroSetting) {
                this.settings.add(new MacroBox(this, next, this.settingOffset));
            }
            this.settingOffset += parent.getHeight();
        }
    }

    public void render(class_332 drawContext, int n, int n2, float n3) {
        if (this.parent.getY() + this.offset <= class_310.method_1551().method_22683().method_4507()) {
            Iterator<Component> iterator = this.settings.iterator();
            while (iterator.hasNext()) {
                iterator.next().onUpdate();
            }
            this.updateAnimations(n, n2, n3);
            int x = this.parent.getX();
            int n4 = this.parent.getY() + this.offset;
            int width = this.parent.getWidth();
            int height = this.parent.getHeight();
            this.renderButtonBackground(drawContext, x, n4, width, height);
            this.renderIndicator(drawContext, x, n4, height);
            this.renderModuleInfo(drawContext, x, n4, width, height);
            if (this.extended) {
                this.renderSettings(drawContext, n, n2, n3);
            }
            if (this.isHovered(n, n2) && !this.parent.dragging) {
                DonutBBC.INSTANCE.GUI.setTooltip(this.module.getDescription(), n + 10, n2 + 10);
            }
        }
    }

    private void updateAnimations(int n, int n2, float n3) {
        float n4 = n3 * 0.05f;
        float n5 = this.isHovered(n, n2) && !this.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, n5, 0.05f, n4);
        float n6 = this.module.isEnabled() ? 1.0f : 0.0f;
        this.enabledAnimation = (float)MathUtil.exponentialInterpolate(this.enabledAnimation, n6, 0.005f, n4);
        this.enabledAnimation = (float)MathUtil.clampValue(this.enabledAnimation, 0.0, 1.0);
    }

    private void renderButtonBackground(class_332 drawContext, int n, int n2, int n3, int n4) {
        boolean b;
        Color a = ColorUtil.keyCodec(new Color(25, 25, 30, 230), this.HOVER_COLOR, this.hoverAnimation);
        boolean bl = b = this.parent.moduleButtons.get(this.parent.moduleButtons.size() - 1) == this;
        if (b && !this.extended) {
            RenderUtils.renderRoundedQuad(drawContext.method_51448(), a, n, n2, n + n3, n2 + n4, 0.0, 0.0, 6.0, 6.0, 50.0);
        } else if (b && this.extended) {
            RenderUtils.renderRoundedQuad(drawContext.method_51448(), a, n, n2, n + n3, n2 + n4, 0.0, 0.0, 0.0, 0.0, 50.0);
        } else {
            drawContext.method_25294(n, n2, n + n3, n2 + n4, a.getRGB());
        }
        if (this.parent.moduleButtons.indexOf(this) > 0) {
            drawContext.method_25294(n + 4, n2, n + n3 - 4, n2 + 1, new Color(60, 60, 65, 100).getRGB());
        }
    }

    private void renderIndicator(class_332 drawContext, int n, int n2, int n3) {
        Color color = this.module.isEnabled() ? Utils.getMainColor(255, DonutBBC.INSTANCE.getModuleManager().keyCodec(this.module.getCategory()).indexOf(this.module)) : this.ACCENT_COLOR;
        float n4 = 5.0f * this.enabledAnimation;
        if (n4 > 0.1f) {
            RenderUtils.renderRoundedQuad(drawContext.method_51448(), ColorUtil.keyCodec(this.DISABLED_COLOR, color, this.enabledAnimation), n, n2 + 2, (float)n + n4, n2 + n3 - 2, 1.5, 1.5, 1.5, 1.5, 60.0);
        }
    }

    private void renderModuleInfo(class_332 drawContext, int n, int n2, int n3, int n4) {
        TextRenderer.drawString(this.module.getName(), drawContext, n + 10, n2 + n4 / 2 - 6, ColorUtil.keyCodec(this.DISABLED_COLOR, this.ENABLED_COLOR, this.enabledAnimation).getRGB());
        int n5 = n + n3 - 40;
        int n6 = n2 + n4 / 2 - 6;
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), ColorUtil.keyCodec(new Color(60, 60, 65, 200), new Color(236, 153, 181), this.enabledAnimation), n5, n6, (float)n5 + 24.0f, (float)n6 + 12.0f, 6.0, 6.0, 6.0, 6.0, 50.0);
        float n7 = (float)n5 + 6.0f + 12.0f * this.enabledAnimation;
        RenderUtils.renderCircle(drawContext.method_51448(), ColorUtil.keyCodec(new Color(180, 180, 180), this.ENABLED_COLOR, this.enabledAnimation), n7, (float)n6 + 6.0f, 5.0, 12);
        if (this.module.isEnabled()) {
            RenderUtils.renderCircle(drawContext.method_51448(), new Color(this.ENABLED_COLOR.getRed(), this.ENABLED_COLOR.getGreen(), this.ENABLED_COLOR.getBlue(), 30), n7, (float)n6 + 6.0f, 8.0, 16);
        }
    }

    private void renderSettings(class_332 drawContext, int n, int n2, float n3) {
        int n4 = this.parent.getY() + this.offset + this.parent.getHeight();
        double animation = this.animation.getAnimation();
        RenderSystem.enableScissor((int)this.parent.getX(), (int)(DonutBBC.mc.method_22683().method_4507() - (n4 + (int)animation)), (int)this.parent.getWidth(), (int)((int)animation));
        Iterator<Component> iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            iterator.next().render(drawContext, n, n2 - n4, n3);
        }
        this.renderSliderControls(drawContext);
        RenderSystem.disableScissor();
    }

    private void renderSliderControls(class_332 drawContext) {
        for (Component next : this.settings) {
            if (next instanceof NumberBox) {
                NumberBox numberBox = (NumberBox)next;
                this.renderModernSliderKnob(drawContext, (double)next.parentX() + Math.max(numberBox.lerpedOffsetX, 2.5), (double)(next.parentY() + numberBox.offset + next.parentOffset()) + 27.5, numberBox.currentColor1);
                continue;
            }
            if (!(next instanceof Slider)) continue;
            this.renderModernSliderKnob(drawContext, (double)next.parentX() + Math.max(((Slider)next).lerpedOffsetMinX, 2.5), (double)(next.parentY() + next.offset + next.parentOffset()) + 27.5, ((Slider)next).accentColor1);
            this.renderModernSliderKnob(drawContext, (double)next.parentX() + Math.max(((Slider)next).lerpedOffsetMaxX, 2.5), (double)(next.parentY() + next.offset + next.parentOffset()) + 27.5, ((Slider)next).accentColor1);
        }
    }

    private void renderModernSliderKnob(class_332 drawContext, double n, double n2, Color color) {
        RenderUtils.renderCircle(drawContext.method_51448(), new Color(0, 0, 0, 100), n, n2, 7.0, 18);
        RenderUtils.renderCircle(drawContext.method_51448(), color, n, n2, 5.5, 16);
        RenderUtils.renderCircle(drawContext.method_51448(), new Color(255, 255, 255, 70), n, n2 - 1.0, 3.0, 12);
    }

    public void onExtend() {
        Iterator<ModuleButton> iterator = this.parent.moduleButtons.iterator();
        while (iterator.hasNext()) {
            iterator.next().extended = false;
        }
    }

    public void keyPressed(int n, int n2, int n3) {
        Iterator<Component> iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            iterator.next().keyPressed(n, n2, n3);
        }
    }

    public void mouseDragged(double n, double n2, int n3, double n4, double n5) {
        if (this.extended) {
            Iterator<Component> iterator = this.settings.iterator();
            while (iterator.hasNext()) {
                iterator.next().mouseDragged(n, n2, n3, n4, n5);
            }
        }
    }

    public void mouseClicked(double n, double n2, int button) {
        if (this.isHovered(n, n2)) {
            if (button == 0) {
                int n4 = this.parent.getX() + this.parent.getWidth() - 30;
                int n5 = this.parent.getY() + this.offset + this.parent.getHeight() / 2 - 3;
                if (n >= (double)n4 && n <= (double)(n4 + 12) && n2 >= (double)n5 && n2 <= (double)(n5 + 6)) {
                    this.module.toggle();
                } else if (!this.module.getSettings().isEmpty() && n > (double)(this.parent.getX() + this.parent.getWidth() - 25)) {
                    if (!this.extended) {
                        this.onExtend();
                    }
                    this.extended = !this.extended;
                } else {
                    this.module.toggle();
                }
            } else if (button == 1) {
                if (this.module.getSettings().isEmpty()) {
                    return;
                }
                if (!this.extended) {
                    this.onExtend();
                }
                boolean bl = this.extended = !this.extended;
            }
        }
        if (this.extended) {
            for (Component setting : this.settings) {
                setting.mouseClicked(n, n2, button);
            }
        }
    }

    public void onGuiClose() {
        this.currentAlpha = null;
        this.currentColor = null;
        this.hoverAnimation = 0.0f;
        float enabledAnimation = this.module.isEnabled() ? 1.0f : 0.0f;
        this.enabledAnimation = enabledAnimation;
        Iterator<Component> iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            iterator.next().onGuiClose();
        }
    }

    public void mouseReleased(double n, double n2, int n3) {
        Iterator<Component> iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            iterator.next().mouseReleased(n, n2, n3);
        }
    }

    public boolean isHovered(double n, double n2) {
        return n > (double)this.parent.getX() && n < (double)(this.parent.getX() + this.parent.getWidth()) && n2 > (double)(this.parent.getY() + this.offset) && n2 < (double)(this.parent.getY() + this.offset + this.parent.getHeight());
    }
}

