/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.gui.components;

import java.awt.Color;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import skid.gypsyy.gui.Component;
import skid.gypsyy.gui.components.ModuleButton;
import skid.gypsyy.module.setting.MinMaxSetting;
import skid.gypsyy.module.setting.Setting;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.MathUtil;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.TextRenderer;
import skid.gypsyy.utils.Utils;

public final class Slider
extends Component {
    private boolean draggingMin;
    private boolean draggingMax;
    private double offsetMinX;
    private double offsetMaxX;
    public double lerpedOffsetMinX;
    public double lerpedOffsetMaxX;
    private float hoverAnimation = 0.0f;
    private final MinMaxSetting setting;
    public Color accentColor1;
    public Color accentColor2;
    private static final Color TEXT_COLOR = new Color(230, 230, 230);
    private static final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private static final Color TRACK_BG_COLOR = new Color(60, 60, 65);
    private static final Color THUMB_COLOR = new Color(240, 240, 240);
    private static final float TRACK_HEIGHT = 4.0f;
    private static final float TRACK_RADIUS = 2.0f;
    private static final float THUMB_SIZE = 8.0f;
    private static final float ANIMATION_SPEED = 0.25f;

    public Slider(ModuleButton moduleButton, Setting setting, int n) {
        super(moduleButton, setting, n);
        this.setting = (MinMaxSetting)setting;
        this.lerpedOffsetMinX = this.parentX();
        this.lerpedOffsetMaxX = this.parentX() + this.parentWidth();
    }

    @Override
    public void render(class_332 drawContext, int n, int n2, float n3) {
        super.render(drawContext, n, n2, n3);
        class_4587 matrices = drawContext.method_51448();
        this.updateAnimations(n, n2, n3);
        this.offsetMinX = (this.setting.getCurrentMin() - this.setting.getMinValue()) / (this.setting.getMaxValue() - this.setting.getMinValue()) * (double)(this.parentWidth() - 10) + 5.0;
        this.offsetMaxX = (this.setting.getCurrentMax() - this.setting.getMinValue()) / (this.setting.getMaxValue() - this.setting.getMinValue()) * (double)(this.parentWidth() - 10) + 5.0;
        this.lerpedOffsetMinX = MathUtil.approachValue((float)(0.5 * (double)n3), this.lerpedOffsetMinX, this.offsetMinX);
        this.lerpedOffsetMaxX = MathUtil.approachValue((float)(0.5 * (double)n3), this.lerpedOffsetMaxX, this.offsetMaxX);
        if (!this.parent.parent.dragging) {
            drawContext.method_25294(this.parentX(), this.parentY() + this.parentOffset() + this.offset, this.parentX() + this.parentWidth(), this.parentY() + this.parentOffset() + this.offset + this.parentHeight(), new Color(HOVER_COLOR.getRed(), HOVER_COLOR.getGreen(), HOVER_COLOR.getBlue(), (int)((float)HOVER_COLOR.getAlpha() * this.hoverAnimation)).getRGB());
        }
        int n4 = this.parentY() + this.offset + this.parentOffset() + 25;
        int n5 = this.parentX() + 5;
        RenderUtils.renderRoundedQuad(matrices, TRACK_BG_COLOR, n5, n4, n5 + (this.parentWidth() - 10), (float)n4 + 4.0f, 2.0, 2.0, 2.0, 2.0, 50.0);
        if (this.lerpedOffsetMaxX > this.lerpedOffsetMinX) {
            RenderUtils.renderRoundedQuad(matrices, this.accentColor1, (double)n5 + this.lerpedOffsetMinX - 5.0, n4, (double)n5 + this.lerpedOffsetMaxX - 5.0, (float)n4 + 4.0f, 2.0, 2.0, 2.0, 2.0, 50.0);
        }
        String displayText = this.getDisplayText();
        TextRenderer.drawString(this.setting.getName(), drawContext, this.parentX() + 5, this.parentY() + this.parentOffset() + this.offset + 9, TEXT_COLOR.getRGB());
        TextRenderer.drawString(displayText, drawContext, this.parentX() + this.parentWidth() - TextRenderer.getWidth(displayText) - 5, this.parentY() + this.parentOffset() + this.offset + 9, this.accentColor1.getRGB());
        float n6 = (float)n4 + 2.0f - 4.0f;
        RenderUtils.renderRoundedQuad(matrices, THUMB_COLOR, (float)((double)n5 + this.lerpedOffsetMinX - 5.0 - 4.0), n6, (float)((double)n5 + this.lerpedOffsetMinX - 5.0 + 4.0), n6 + 8.0f, 4.0, 4.0, 4.0, 4.0, 50.0);
        RenderUtils.renderRoundedQuad(matrices, THUMB_COLOR, (float)((double)n5 + this.lerpedOffsetMaxX - 5.0 - 4.0), n6, (float)((double)n5 + this.lerpedOffsetMaxX - 5.0 + 4.0), n6 + 8.0f, 4.0, 4.0, 4.0, 4.0, 50.0);
    }

    private void updateAnimations(int n, int n2, float n3) {
        float n4 = this.isHovered(n, n2) && !this.parent.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, n4, 0.25, n3 * 0.05f);
    }

    private String getDisplayText() {
        return this.setting.getCurrentMin() == this.setting.getCurrentMax() ? this.formatValue(this.setting.getCurrentMin()) : this.formatValue(this.setting.getCurrentMin()) + " - " + this.formatValue(this.setting.getCurrentMax());
    }

    private String formatValue(double value) {
        double step = this.setting.getStep();
        if (step == 0.1) {
            return String.format("%.1f", value);
        }
        if (step == 0.01) {
            return String.format("%.2f", value);
        }
        if (step == 0.001) {
            return String.format("%.3f", value);
        }
        return step >= 1.0 ? String.format("%.0f", value) : String.valueOf(value);
    }

    @Override
    public void mouseClicked(double n, double n2, int n3) {
        if (n3 == 0 && this.isHovered(n, n2)) {
            if (this.isHoveredMin(n, n2)) {
                this.draggingMin = true;
                this.slideMin(n);
            } else if (this.isHoveredMax(n, n2)) {
                this.draggingMax = true;
                this.slideMax(n);
            } else if (n < (double)this.parentX() + this.offsetMinX) {
                this.draggingMin = true;
                this.slideMin(n);
            } else if (n > (double)this.parentX() + this.offsetMaxX) {
                this.draggingMax = true;
                this.slideMax(n);
            } else if (n - ((double)this.parentX() + this.offsetMinX) < (double)this.parentX() + this.offsetMaxX - n) {
                this.draggingMin = true;
                this.slideMin(n);
            } else {
                this.draggingMax = true;
                this.slideMax(n);
            }
        }
        super.mouseClicked(n, n2, n3);
    }

    @Override
    public void keyPressed(int n, int n2, int n3) {
        if (this.mouseOver && n == 259) {
            this.setting.setCurrentMax(this.setting.getDefaultMax());
            this.setting.setCurrentMin(this.setting.getDefaultMin());
        }
        super.keyPressed(n, n2, n3);
    }

    public boolean isHoveredMin(double n, double n2) {
        return this.isHovered(n, n2) && n > (double)this.parentX() + this.offsetMinX - 8.0 && n < (double)this.parentX() + this.offsetMinX + 8.0;
    }

    public boolean isHoveredMax(double n, double n2) {
        return this.isHovered(n, n2) && n > (double)this.parentX() + this.offsetMaxX - 8.0 && n < (double)this.parentX() + this.offsetMaxX + 8.0;
    }

    @Override
    public void mouseReleased(double n, double n2, int n3) {
        if (n3 == 0) {
            this.draggingMin = false;
            this.draggingMax = false;
        }
        super.mouseReleased(n, n2, n3);
    }

    @Override
    public void mouseDragged(double n, double n2, int n3, double n4, double n5) {
        if (this.draggingMin) {
            this.slideMin(n);
        }
        if (this.draggingMax) {
            this.slideMax(n);
        }
        super.mouseDragged(n, n2, n3, n4, n5);
    }

    @Override
    public void onGuiClose() {
        this.accentColor1 = null;
        this.accentColor2 = null;
        this.hoverAnimation = 0.0f;
        super.onGuiClose();
    }

    private void slideMin(double n) {
        this.setting.setCurrentMin(Math.min(MathUtil.roundToNearest(class_3532.method_15350((double)((n - (double)(this.parentX() + 5)) / (double)(this.parentWidth() - 10)), (double)0.0, (double)1.0) * (this.setting.getMaxValue() - this.setting.getMinValue()) + this.setting.getMinValue(), this.setting.getStep()), this.setting.getCurrentMax()));
    }

    private void slideMax(double n) {
        this.setting.setCurrentMax(Math.max(MathUtil.roundToNearest(class_3532.method_15350((double)((n - (double)(this.parentX() + 5)) / (double)(this.parentWidth() - 10)), (double)0.0, (double)1.0) * (this.setting.getMaxValue() - this.setting.getMinValue()) + this.setting.getMinValue(), this.setting.getStep()), this.setting.getCurrentMin()));
    }

    @Override
    public void onUpdate() {
        Color mainColor = Utils.getMainColor(255, this.parent.settings.indexOf(this));
        Color mainColor2 = Utils.getMainColor(255, this.parent.settings.indexOf(this) + 1);
        this.accentColor1 = this.accentColor1 == null ? new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), 0) : new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), this.accentColor1.getAlpha());
        this.accentColor2 = this.accentColor2 == null ? new Color(mainColor2.getRed(), mainColor2.getGreen(), mainColor2.getBlue(), 0) : new Color(mainColor2.getRed(), mainColor2.getGreen(), mainColor2.getBlue(), this.accentColor2.getAlpha());
        if (this.accentColor1.getAlpha() != 255) {
            this.accentColor1 = ColorUtil.keyCodec(0.05f, 255, this.accentColor1);
        }
        if (this.accentColor2.getAlpha() != 255) {
            this.accentColor2 = ColorUtil.keyCodec(0.05f, 255, this.accentColor2);
        }
        super.onUpdate();
    }
}

