/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import skid.gypsyy.DonutBBC;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BindSetting;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.ItemSetting;
import skid.gypsyy.module.setting.MacroSetting;
import skid.gypsyy.module.setting.MinMaxSetting;
import skid.gypsyy.module.setting.ModeSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.module.setting.Setting;
import skid.gypsyy.module.setting.StringSetting;
import skid.gypsyy.utils.EncryptedString;

public final class ConfigManager {
    private JsonObject jsonObject;
    private final File configFile;
    private final Gson gson;

    public ConfigManager() {
        String userHome = System.getProperty("user.home");
        String configDir = userHome + File.separator + ".minecraft" + File.separator + "config";
        File configFolder = new File(configDir);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        this.configFile = new File(configFolder, "krypton_config.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.jsonObject = new JsonObject();
        this.loadConfigFromFile();
    }

    private void loadConfigFromFile() {
        block9: {
            try {
                if (this.configFile.exists()) {
                    try (FileReader reader = new FileReader(this.configFile);){
                        this.jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                        if (this.jsonObject == null) {
                            this.jsonObject = new JsonObject();
                        }
                        break block9;
                    }
                }
                this.jsonObject = new JsonObject();
            }
            catch (Exception var6) {
                System.err.println("[ConfigManager] Error loading config file: " + var6.getMessage());
                var6.printStackTrace();
                this.jsonObject = new JsonObject();
            }
        }
    }

    public void loadProfile() {
        if (class_310.method_1551() == null) {
            return;
        }
        try {
            if (this.jsonObject == null) {
                this.jsonObject = new JsonObject();
                return;
            }
            int modulesLoaded = 0;
            for (Module next : DonutBBC.INSTANCE.getModuleManager().c()) {
                try {
                    String moduleName = this.getModuleName(next);
                    JsonElement value = this.jsonObject.get(moduleName);
                    if (value == null || !value.isJsonObject()) continue;
                    JsonObject asJsonObject = value.getAsJsonObject();
                    JsonElement value2 = asJsonObject.get("enabled");
                    if (value2 != null && value2.isJsonPrimitive() && value2.getAsBoolean()) {
                        try {
                            next.toggle(true);
                        }
                        catch (Exception e) {
                            System.err.println("[ConfigManager] Error enabling module " + moduleName + " during config load: " + e.getMessage());
                        }
                    }
                    for (Setting next2 : next.getSettings()) {
                        try {
                            String settingName = this.getSettingName(next2);
                            JsonElement value3 = asJsonObject.get(settingName);
                            if (value3 == null) continue;
                            this.setValueFromJson(next2, value3, next);
                        }
                        catch (Exception var12) {
                            System.err.println("[ConfigManager] Error loading setting for module " + moduleName + ": " + var12.getMessage());
                        }
                    }
                    ++modulesLoaded;
                }
                catch (Exception var13) {
                    System.err.println("[ConfigManager] Error loading module: " + var13.getMessage());
                }
            }
        }
        catch (Exception var14) {
            System.err.println("[ConfigManager] Error loading profile: " + var14.getMessage());
            var14.printStackTrace();
        }
    }

    private String getModuleName(Module module) {
        try {
            CharSequence name = module.getName();
            return name instanceof EncryptedString ? ((EncryptedString)name).toString() : name.toString();
        }
        catch (Exception var3) {
            return "Module_" + module.hashCode();
        }
    }

    private String getSettingName(Setting setting) {
        try {
            CharSequence name = setting.getName();
            return name instanceof EncryptedString ? ((EncryptedString)name).toString() : name.toString();
        }
        catch (Exception var3) {
            return "Setting_" + setting.hashCode();
        }
    }

    private void setValueFromJson(Setting setting, JsonElement jsonElement, Module module) {
        try {
            if (setting instanceof BooleanSetting) {
                BooleanSetting booleanSetting = (BooleanSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    booleanSetting.setValue(jsonElement.getAsBoolean());
                }
            } else if (setting instanceof ModeSetting) {
                ModeSetting enumSetting = (ModeSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    int asInt = jsonElement.getAsInt();
                    if (asInt != -1) {
                        enumSetting.setModeIndex(asInt);
                    } else {
                        enumSetting.setModeIndex(enumSetting.getOriginalValue());
                    }
                }
            } else if (setting instanceof NumberSetting) {
                NumberSetting numberSetting = (NumberSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    numberSetting.getValue(jsonElement.getAsDouble());
                }
            } else if (setting instanceof BindSetting) {
                BindSetting bindSetting = (BindSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    int asInt2 = jsonElement.getAsInt();
                    bindSetting.setValue(asInt2);
                    if (bindSetting.isModuleKey()) {
                        module.setKeybind(asInt2);
                    }
                }
            } else if (setting instanceof StringSetting) {
                StringSetting stringSetting = (StringSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    stringSetting.setValue(jsonElement.getAsString());
                }
            } else if (setting instanceof MinMaxSetting) {
                JsonObject asJsonObject;
                MinMaxSetting minMaxSetting = (MinMaxSetting)setting;
                if (jsonElement.isJsonObject() && (asJsonObject = jsonElement.getAsJsonObject()).has("min") && asJsonObject.has("max")) {
                    double asDouble = asJsonObject.get("min").getAsDouble();
                    double asDouble2 = asJsonObject.get("max").getAsDouble();
                    minMaxSetting.setCurrentMin(asDouble);
                    minMaxSetting.setCurrentMax(asDouble2);
                }
            } else if (setting instanceof ItemSetting && jsonElement.isJsonPrimitive()) {
                ((ItemSetting)setting).setItem((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)jsonElement.getAsString())));
            } else if (setting instanceof MacroSetting && jsonElement.isJsonArray()) {
                MacroSetting macroSetting = (MacroSetting)setting;
                macroSetting.clearCommands();
                for (JsonElement element : jsonElement.getAsJsonArray()) {
                    if (!element.isJsonPrimitive()) continue;
                    macroSetting.addCommand(element.getAsString());
                }
            }
        }
        catch (Exception var15) {
            System.err.println("[ConfigManager] Error setting value from JSON: " + var15.getMessage());
        }
    }

    private void saveConfigToFile() {
        try {
            File parentDir = this.configFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (FileWriter writer = new FileWriter(this.configFile);){
                this.gson.toJson((JsonElement)this.jsonObject, (Appendable)writer);
            }
        }
        catch (IOException var7) {
            System.err.println("[ConfigManager] Error saving config file: " + var7.getMessage());
            var7.printStackTrace();
        }
    }

    public void saveConfig() {
        this.shutdown();
    }

    public void manualSave() {
        this.shutdown();
    }

    public void reloadConfig() {
        this.loadConfigFromFile();
        this.loadProfile();
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void shutdown() {
        try {
            this.jsonObject = new JsonObject();
            int modulesSaved = 0;
            for (Module module : DonutBBC.INSTANCE.getModuleManager().c()) {
                try {
                    String moduleName = this.getModuleName(module);
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("enabled", Boolean.valueOf(module.isEnabled()));
                    for (Setting setting : module.getSettings()) {
                        try {
                            this.save(setting, jsonObject, module);
                        }
                        catch (Exception var9) {
                            System.err.println("[ConfigManager] Error saving setting for module " + moduleName + ": " + var9.getMessage());
                        }
                    }
                    this.jsonObject.add(moduleName, (JsonElement)jsonObject);
                    ++modulesSaved;
                }
                catch (Exception var10) {
                    System.err.println("[ConfigManager] Error saving module: " + var10.getMessage());
                }
            }
            this.saveConfigToFile();
        }
        catch (Exception var11) {
            System.err.println("[ConfigManager] Error during shutdown: " + var11.getMessage());
            var11.printStackTrace(System.err);
        }
    }

    private void save(Setting setting, JsonObject jsonObject, Module module) {
        try {
            String settingName = this.getSettingName(setting);
            if (setting instanceof BooleanSetting) {
                BooleanSetting booleanSetting = (BooleanSetting)setting;
                jsonObject.addProperty(settingName, Boolean.valueOf(booleanSetting.getValue()));
            } else if (setting instanceof ModeSetting) {
                ModeSetting enumSetting = (ModeSetting)setting;
                jsonObject.addProperty(settingName, (Number)enumSetting.getModeIndex());
            } else if (setting instanceof NumberSetting) {
                NumberSetting numberSetting = (NumberSetting)setting;
                jsonObject.addProperty(settingName, (Number)numberSetting.getValue());
            } else if (setting instanceof BindSetting) {
                BindSetting bindSetting = (BindSetting)setting;
                jsonObject.addProperty(settingName, (Number)bindSetting.getValue());
            } else if (setting instanceof StringSetting) {
                StringSetting stringSetting = (StringSetting)setting;
                jsonObject.addProperty(settingName, stringSetting.getValue());
            } else if (setting instanceof MinMaxSetting) {
                JsonObject jsonObject2 = new JsonObject();
                jsonObject2.addProperty("min", (Number)((MinMaxSetting)setting).getCurrentMin());
                jsonObject2.addProperty("max", (Number)((MinMaxSetting)setting).getCurrentMax());
                jsonObject.add(settingName, (JsonElement)jsonObject2);
            } else if (setting instanceof ItemSetting) {
                ItemSetting itemSetting = (ItemSetting)setting;
                jsonObject.addProperty(settingName, class_7923.field_41178.method_10221((Object)itemSetting.getItem()).toString());
            } else if (setting instanceof MacroSetting) {
                MacroSetting macroSetting = (MacroSetting)setting;
                JsonArray commandsArray = new JsonArray();
                for (String command : macroSetting.getCommands()) {
                    commandsArray.add(command);
                }
                jsonObject.add(settingName, (JsonElement)commandsArray);
            }
        }
        catch (Exception var16) {
            Object settingNamex = "Unknown";
            try {
                settingNamex = this.getSettingName(setting);
            }
            catch (Exception var15) {
                settingNamex = "Setting_" + setting.hashCode();
            }
            System.err.println("[ConfigManager] Error saving setting " + (String)settingNamex + ": " + var16.getMessage());
        }
    }
}

