/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.manager;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import skid.gypsyy.DonutBBC;
import skid.gypsyy.event.CancellableEvent;
import skid.gypsyy.event.Event;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.Listener;
import skid.gypsyy.module.Module;

public final class EventManager {
    private final Map<Class<?>, List<Listener>> EVENTS = new HashMap();

    public void register(Object o) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = o.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(EventListener.class) || method.getParameterCount() != 1 || !Event.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
            this.addListener(o, method, method.getAnnotation(EventListener.class));
        }
    }

    private void addListener(Object o, Method method, EventListener eventListener) {
        Class<?> key = method.getParameterTypes()[0];
        method.setAccessible(true);
        this.EVENTS.computeIfAbsent(key, p0 -> new CopyOnWriteArrayList()).add(new Listener(o, method, eventListener.priority()));
        this.EVENTS.get(key).sort(Comparator.comparingInt(listener -> listener.getPriority().getValue()));
    }

    public void unregister(Object object) {
        for (List<Listener> listeners : this.EVENTS.values()) {
            listeners.removeIf(listener -> listener.getInstance() == object);
        }
    }

    public void clear() {
        this.EVENTS.clear();
    }

    public void keyCodec(Event event) {
        List<Listener> listeners = this.EVENTS.get(event.getClass());
        if (listeners != null) {
            for (Listener listener : listeners) {
                try {
                    Object holder = listener.getInstance();
                    if (holder instanceof Module && !((Module)holder).isEnabled() || event.isCancelled() && !(event instanceof CancellableEvent)) continue;
                    listener.invoke(event);
                }
                catch (Throwable var6) {
                    System.err.println("Error dispatching event " + event.getClass().getSimpleName() + " to " + (listener.getInstance() != null ? listener.getInstance().getClass().getSimpleName() : "unknown"));
                    var6.printStackTrace(System.err);
                }
            }
        }
    }

    public static void elementCodec(Event event) {
        if (DonutBBC.INSTANCE != null && DonutBBC.INSTANCE.getEventBus() != null) {
            DonutBBC.INSTANCE.getEventBus().keyCodec(event);
        }
    }
}

