/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.manager;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

public class ShaderManager {
    private static class_5944 roundedQuadShader;
    private static int vao;
    private static int vbo;
    private static boolean initialized;

    public static void init(class_3300 resourceManager) {
        if (!initialized) {
            try {
                roundedQuadShader = new class_5944((class_5912)resourceManager, "krypton:rounded_quad", class_290.field_1585);
                vao = GL30.glGenVertexArrays();
                vbo = GL20.glGenBuffers();
                ShaderManager.setupVertexData();
                initialized = true;
            }
            catch (IOException var2) {
                System.err.println("Failed to initialize shaders: " + var2.getMessage());
                var2.printStackTrace();
            }
        }
    }

    private static void setupVertexData() {
        float[] vertices = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        GL30.glBindVertexArray((int)vao);
        GL20.glBindBuffer((int)34962, (int)vbo);
        FloatBuffer buffer = MemoryUtil.memAllocFloat((int)vertices.length);
        buffer.put(vertices).flip();
        GL20.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        MemoryUtil.memFree((Buffer)buffer);
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)16, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)16, (long)8L);
        GL20.glEnableVertexAttribArray((int)1);
        GL30.glBindVertexArray((int)0);
    }

    public static void renderRoundedQuad(float x, float y, float width, float height, float r, float g, float b, float a, float topLeft, float topRight, float bottomRight, float bottomLeft) {
        if (initialized && roundedQuadShader != null) {
            try {
                roundedQuadShader.method_34586();
                int programId = GL20.glGetInteger((int)35725);
                int colorLocation = GL20.glGetUniformLocation((int)programId, (CharSequence)"color");
                int sizeLocation = GL20.glGetUniformLocation((int)programId, (CharSequence)"size");
                int radiusLocation = GL20.glGetUniformLocation((int)programId, (CharSequence)"radius");
                int smoothnessLocation = GL20.glGetUniformLocation((int)programId, (CharSequence)"smoothness");
                if (colorLocation != -1) {
                    GL20.glUniform4f((int)colorLocation, (float)r, (float)g, (float)b, (float)a);
                }
                if (sizeLocation != -1) {
                    GL20.glUniform2f((int)sizeLocation, (float)width, (float)height);
                }
                if (radiusLocation != -1) {
                    GL20.glUniform4f((int)radiusLocation, (float)topLeft, (float)topRight, (float)bottomRight, (float)bottomLeft);
                }
                if (smoothnessLocation != -1) {
                    GL20.glUniform1f((int)smoothnessLocation, (float)1.0f);
                }
                int projectionLocation = GL20.glGetUniformLocation((int)programId, (CharSequence)"projection");
                int modelLocation = GL20.glGetUniformLocation((int)programId, (CharSequence)"model");
                class_310 client = class_310.method_1551();
                if (client != null && client.method_22683() != null) {
                    float[] projection = ShaderManager.createOrthographicMatrix(0.0f, client.method_22683().method_4486(), 0.0f, client.method_22683().method_4502(), -1.0f, 1.0f);
                    if (projectionLocation != -1) {
                        GL20.glUniformMatrix4fv((int)projectionLocation, (boolean)false, (float[])projection);
                    }
                }
                float[] model = ShaderManager.createModelMatrix(x, y, width, height);
                if (modelLocation != -1) {
                    GL20.glUniformMatrix4fv((int)modelLocation, (boolean)false, (float[])model);
                }
                GL30.glBindVertexArray((int)vao);
                GL20.glDrawArrays((int)6, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                roundedQuadShader.method_34585();
            }
            catch (Exception var21) {
                System.err.println("Error rendering rounded quad with shader: " + var21.getMessage());
            }
        }
    }

    private static float[] createOrthographicMatrix(float left, float right, float bottom, float top, float near, float far) {
        return new float[]{2.0f / (right - left), 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / (top - bottom), 0.0f, 0.0f, 0.0f, 0.0f, -2.0f / (far - near), 0.0f, -(right + left) / (right - left), -(top + bottom) / (top - bottom), -(far + near) / (far - near), 1.0f};
    }

    private static float[] createModelMatrix(float x, float y, float width, float height) {
        return new float[]{width, 0.0f, 0.0f, 0.0f, 0.0f, height, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, x, y, 0.0f, 1.0f};
    }

    public static void cleanup() {
        if (vao != 0) {
            GL30.glDeleteVertexArrays((int)vao);
            vao = 0;
        }
        if (vbo != 0) {
            GL20.glDeleteBuffers((int)vbo);
            vbo = 0;
        }
        initialized = false;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

