/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.donut;

import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.ChunkDataEvent;
import skid.gypsyy.event.events.Render3DEvent;
import skid.gypsyy.event.events.SetBlockStateEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.module.setting.StringSetting;
import skid.gypsyy.utils.BlockUtil;
import skid.gypsyy.utils.EncryptedString;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.meteorrejects.Ore;

public final class NetheriteFinder
extends Module {
    private final NumberSetting alpha = new NumberSetting(EncryptedString.of("Alpha"), 1.0, 255.0, 125.0, 1.0);
    private final NumberSetting range = new NumberSetting(EncryptedString.of("Range"), 1.0, 10.0, 5.0, 1.0);
    private final StringSetting customSeed = new StringSetting(EncryptedString.of("Custom Seed"), "6608149111735331168");
    private final Map<Long, Map<Ore, Set<class_243>>> chunkOreData = new ConcurrentHashMap<Long, Map<Ore, Set<class_243>>>();
    private Map<class_5321<class_1959>, List<Ore>> biomeOreMap;

    public NetheriteFinder() {
        super(EncryptedString.of("Netherite Finder"), EncryptedString.of("Finds netherites"), -1, Category.DONUT);
        this.addsettings(this.alpha, this.range, this.customSeed);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.initializeOreLocations();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.chunkOreData.clear();
    }

    @EventListener
    public void onRender3D(Render3DEvent renderEvent) {
        if (this.mc.field_1724 != null && this.biomeOreMap != null) {
            class_4184 camera = this.mc.field_1773.method_19418();
            if (camera != null) {
                class_4587 matrixStack = renderEvent.matrixStack;
                renderEvent.matrixStack.method_22903();
                class_243 cameraPos = camera.method_19326();
                class_7833 xAxis = class_7833.field_40714;
                matrixStack.method_22907(xAxis.rotationDegrees(camera.method_19329()));
                class_7833 yAxis = class_7833.field_40716;
                matrixStack.method_22907(yAxis.rotationDegrees(camera.method_19330() + 180.0f));
                matrixStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
            }
            int playerChunkX = this.mc.field_1724.method_31476().field_9181;
            int playerChunkZ = this.mc.field_1724.method_31476().field_9180;
            int renderRange = this.range.getIntValue();
            for (int x = playerChunkX - renderRange; x <= playerChunkX + renderRange; ++x) {
                for (int z = playerChunkZ - renderRange; z <= playerChunkZ + renderRange; ++z) {
                    this.renderChunk(x, z, renderEvent);
                }
            }
            renderEvent.matrixStack.method_22909();
        }
    }

    private void renderChunk(int chunkX, int chunkZ, Render3DEvent renderEvent) {
        long chunkKey = class_1923.method_8331((int)chunkX, (int)chunkZ);
        Map<Ore, Set<class_243>> chunkData = this.chunkOreData.get(chunkKey);
        if (chunkData != null) {
            for (Map.Entry<Ore, Set<class_243>> entry : chunkData.entrySet()) {
                for (class_243 pos : entry.getValue()) {
                    class_4587 matrixStack = renderEvent.matrixStack;
                    float x = (float)pos.field_1352;
                    float y = (float)pos.field_1351;
                    float z = (float)pos.field_1350;
                    RenderUtils.renderFilledBox(matrixStack, x, y, z, (float)(pos.field_1352 + 1.0), (float)(pos.field_1351 + 1.0), (float)(pos.field_1350 + 1.0), this.getAlphaColor(this.alpha.getIntValue()));
                }
            }
        }
    }

    private void initializeOreLocations() {
        this.chunkOreData.clear();
        if (this.mc.field_1687 != null) {
            this.biomeOreMap = Ore.register();
            this.populateOreLocations();
        }
    }

    private Color getAlphaColor(int alphaValue) {
        return new Color(191, 64, 191, alphaValue);
    }

    @EventListener
    public void onChunkDataReceived(ChunkDataEvent chunkEvent) {
        if (this.biomeOreMap == null && this.mc.field_1687 != null) {
            this.biomeOreMap = Ore.register();
        }
        class_638 world = this.mc.field_1687;
        this.processChunk((class_2791)world.method_8497(chunkEvent.packet.method_11523(), chunkEvent.packet.method_11524()));
    }

    @EventListener
    public void onBlockStateChange(SetBlockStateEvent blockEvent) {
        long chunkKey;
        Map<Ore, Set<class_243>> chunkData;
        if (blockEvent.oldState.method_26204().equals(class_2246.field_10124) && (chunkData = this.chunkOreData.get(chunkKey = class_1923.method_37232((class_2338)blockEvent.pos))) != null) {
            class_243 blockPos = class_243.method_24954((class_2382)blockEvent.pos);
            for (Set<class_243> oreSet : chunkData.values()) {
                oreSet.remove(blockPos);
            }
        }
    }

    private void populateOreLocations() {
        if (this.mc.field_1724 != null) {
            Iterator loadedChunks = BlockUtil.getLoadedChunks().iterator();
            while (loadedChunks.hasNext()) {
                this.processChunk((class_2791)loadedChunks.next());
            }
        }
    }

    private void processChunk(class_2791 chunk) {
        if (this.biomeOreMap != null) {
            class_1923 chunkPos = chunk.method_12004();
            long chunkKey = chunkPos.method_8324();
            class_638 world = this.mc.field_1687;
            if (!this.chunkOreData.containsKey(chunkKey) && world != null) {
                long seedValue;
                HashSet biomesInChunk = new HashSet();
                class_1923.method_19280((class_1923)chunkPos, (int)1).forEach(chunkPos2 -> {
                    class_2791 neighborChunk = world.method_8402(chunkPos2.field_9181, chunkPos2.field_9180, class_2806.field_12794, false);
                    if (neighborChunk != null) {
                        class_2826[] sections = neighborChunk.method_12006();
                        for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
                            sections[sectionIndex].method_38294().method_39793(biome -> biomesInChunk.add((class_5321)biome.method_40230().get()));
                        }
                    }
                });
                Set oresInBiomes = biomesInChunk.stream().flatMap(biome -> this.getOresForBiome((class_5321<class_1959>)biome).stream()).collect(Collectors.toSet());
                int chunkStartX = chunkPos.field_9181 << 4;
                int chunkStartZ = chunkPos.field_9180 << 4;
                class_2919 random = new class_2919(class_2919.class_6675.field_35143.method_39006(0L));
                try {
                    seedValue = Long.parseLong(this.customSeed.getValue());
                }
                catch (NumberFormatException var25) {
                    seedValue = 6608149111735331168L;
                }
                long populationSeed = random.method_12661(seedValue, chunkStartX, chunkStartZ);
                HashMap oreLocations = new HashMap();
                for (Ore ore : oresInBiomes) {
                    HashSet<class_243> orePositions = new HashSet<class_243>();
                    random.method_12664(populationSeed, ore.featureIndex, ore.generationStep);
                    int oreCount = ore.countProvider.method_35008((class_5819)random);
                    for (int oreIndex = 0; oreIndex < oreCount; ++oreIndex) {
                        if (ore.rarityChance != 1.0f) {
                            float rarityThreshold = 1.0f / ore.rarityChance;
                            if (random.method_43057() >= rarityThreshold) continue;
                        }
                        int oreX = random.method_43048(16) + chunkStartX;
                        int oreZ = random.method_43048(16) + chunkStartZ;
                        int oreY = ore.heightProvider.method_35391((class_5819)random, ore.heightContext);
                        class_2338 orePos = new class_2338(oreX, oreY, oreZ);
                        if (!this.getOresForBiome((class_5321<class_1959>)((class_5321)chunk.method_16359(oreX, oreY, oreZ).method_40230().get())).contains(ore)) continue;
                        if (ore.isScatteredOre) {
                            orePositions.addAll(this.generateOreLocations(world, random, orePos, ore.oreSize));
                            continue;
                        }
                        orePositions.addAll(this.generateOreLocations(world, random, orePos, ore.oreSize, ore.discardOnAirChance));
                    }
                    if (orePositions.isEmpty()) continue;
                    oreLocations.put(ore, orePositions);
                }
                this.chunkOreData.put(chunkKey, oreLocations);
            }
        }
    }

    private List<Ore> getOresForBiome(class_5321<class_1959> biome) {
        if (this.biomeOreMap == null) {
            this.biomeOreMap = Ore.register();
        }
        return this.biomeOreMap.containsKey(biome) ? this.biomeOreMap.get(biome) : this.biomeOreMap.values().stream().findAny().get();
    }

    private ArrayList<class_243> generateOreLocations(class_638 world, class_2919 random, class_2338 centerPos, int oreSize, float discardChance) {
        float angle = random.method_43057() * (float)Math.PI;
        float radius = (float)oreSize / 8.0f;
        int maxRadius = class_3532.method_15386((float)(((float)oreSize / 16.0f * 2.0f + 1.0f) / 2.0f));
        int centerX = centerPos.method_10263();
        int centerX2 = centerPos.method_10263();
        double sinAngle = Math.sin(angle);
        int centerZ = centerPos.method_10260();
        int centerZ2 = centerPos.method_10260();
        double cosAngle = Math.cos(angle);
        int centerY = centerPos.method_10264();
        int centerY2 = centerPos.method_10264();
        int minX = centerPos.method_10263() - class_3532.method_15386((float)radius) - maxRadius;
        int minY = centerPos.method_10264() - 2 - maxRadius;
        int minZ = centerPos.method_10260() - class_3532.method_15386((float)radius) - maxRadius;
        int range = 2 * (class_3532.method_15386((float)radius) + maxRadius);
        for (int x = minX; x <= minX + range; ++x) {
            for (int z = minZ; z <= minZ + range; ++z) {
                if (minY > world.method_8624(class_2902.class_2903.field_13197, x, z)) continue;
                return this.generateOreLocations(world, random, oreSize, (double)centerX + Math.sin(angle) * (double)radius, (double)centerX2 - sinAngle * (double)radius, (double)centerZ + Math.cos(angle) * (double)radius, (double)centerZ2 - cosAngle * (double)radius, centerY + random.method_43048(3) - 2, centerY2 + random.method_43048(3) - 2, minX, minY, minZ, range, 2 * (2 + maxRadius), discardChance);
            }
        }
        return new ArrayList<class_243>();
    }

    private ArrayList<class_243> generateOreLocations(class_638 world, class_2919 random, int oreSize, double startX, double endX, double startZ, double endZ, double startY, double endY, int minX, int minY, int minZ, int range, int heightRange, float discardChance) {
        int pointIndex;
        BitSet occupiedPositions = new BitSet(range * heightRange * range);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        double[] orePoints = new double[oreSize * 4];
        ArrayList<class_243> oreLocations = new ArrayList<class_243>();
        for (pointIndex = 0; pointIndex < oreSize; ++pointIndex) {
            float progress = (float)pointIndex / (float)oreSize;
            double x = class_3532.method_16436((double)progress, (double)startX, (double)endX);
            double y = class_3532.method_16436((double)progress, (double)startY, (double)endY);
            double z = class_3532.method_16436((double)progress, (double)startZ, (double)endZ);
            orePoints[pointIndex * 4] = x;
            orePoints[pointIndex * 4 + 1] = y;
            orePoints[pointIndex * 4 + 2] = z;
            orePoints[pointIndex * 4 + 3] = ((double)(class_3532.method_15374((float)((float)Math.PI * progress)) + 1.0f) * (random.method_43058() * (double)oreSize / 16.0) + 1.0) / 2.0;
        }
        for (int i = 0; i < oreSize - 1; ++i) {
            double radius1 = orePoints[i * 4 + 3];
            if (radius1 <= 0.0) continue;
            for (int j = i + 1; j < oreSize; ++j) {
                double z2;
                double z1;
                double dz;
                double y2;
                double y1;
                double dy;
                double x2;
                double x1;
                double dx;
                double r2;
                double r1;
                double dr;
                double radius2 = orePoints[j * 4 + 3];
                if (radius2 <= 0.0 || !((dr = (r1 = orePoints[i * 4 + 3]) - (r2 = orePoints[j * 4 + 3])) * dr > (dx = (x1 = orePoints[i * 4]) - (x2 = orePoints[j * 4])) * dx + (dy = (y1 = orePoints[i * 4 + 1]) - (y2 = orePoints[j * 4 + 1])) * dy + (dz = (z1 = orePoints[i * 4 + 2]) - (z2 = orePoints[j * 4 + 2])) * dz)) continue;
                if (dr > 0.0) {
                    orePoints[j * 4 + 3] = -1.0;
                    continue;
                }
                orePoints[i * 4 + 3] = -1.0;
            }
        }
        for (pointIndex = 0; pointIndex < oreSize; ++pointIndex) {
            int minBlockX;
            double radius = orePoints[pointIndex * 4 + 3];
            if (radius < 0.0) continue;
            double centerX = orePoints[pointIndex * 4];
            double centerY = orePoints[pointIndex * 4 + 1];
            double centerZ = orePoints[pointIndex * 4 + 2];
            int minBlockY = Math.max(class_3532.method_15357((double)(centerY - radius)), minY);
            int minBlockZ = Math.max(class_3532.method_15357((double)(centerZ - radius)), minZ);
            int maxBlockX = Math.max(class_3532.method_15357((double)(centerX + radius)), minBlockX);
            int maxBlockY = Math.max(class_3532.method_15357((double)(centerY + radius)), minBlockY);
            int maxBlockZ = Math.max(class_3532.method_15357((double)(centerZ + radius)), minBlockZ);
            for (minBlockX = Math.max(class_3532.method_15357((double)(centerX - radius)), minX); minBlockX <= maxBlockX; ++minBlockX) {
                double normalizedX = ((double)minBlockX + 0.5 - centerX) / radius;
                if (!(normalizedX * normalizedX < 1.0)) continue;
                while (minBlockY <= maxBlockY) {
                    double normalizedY = ((double)minBlockY + 0.5 - centerY) / radius;
                    if (normalizedX * normalizedX + normalizedY * normalizedY < 1.0 && minBlockZ <= maxBlockZ) {
                        int bitIndex;
                        double normalizedZ = ((double)minBlockZ + 0.5 - centerZ) / radius;
                        if (normalizedX * normalizedX + normalizedY * normalizedY + normalizedZ * normalizedZ < 1.0 && !occupiedPositions.get(bitIndex = minBlockX - minX + (minBlockY - minY) * range + (minBlockZ - minZ) * range * heightRange)) {
                            occupiedPositions.set(bitIndex);
                            blockPos.method_10103(minBlockX, minBlockY, minBlockZ);
                            if (minBlockY >= -64 && minBlockY < 320 && world.method_8320((class_2338)blockPos).method_26225() && this.isValidOreLocation(world, (class_2338)blockPos, discardChance, random)) {
                                oreLocations.add(new class_243((double)minBlockX, (double)minBlockY, (double)minBlockZ));
                            }
                        }
                        ++minBlockZ;
                    }
                    ++minBlockY;
                }
            }
        }
        return oreLocations;
    }

    private boolean isValidOreLocation(class_638 world, class_2338 pos, float discardChance, class_2919 random) {
        if (!(discardChance == 0.0f || discardChance != 1.0f && random.method_43057() >= discardChance)) {
            class_2350[] directions;
            for (class_2350 direction : directions = class_2350.values()) {
                if (world.method_8320(pos.method_10081(direction.method_10163())).method_26225() || discardChance == 1.0f) continue;
                return false;
            }
        }
        return true;
    }

    private ArrayList<class_243> generateOreLocations(class_638 world, class_2919 random, class_2338 centerPos, int oreSize) {
        ArrayList<class_243> oreLocations = new ArrayList<class_243>();
        int actualOreSize = random.method_43048(oreSize + 1);
        for (int oreIndex = 0; oreIndex < actualOreSize; ++oreIndex) {
            int offsetZ;
            int offsetY;
            int maxOffset = Math.min(oreIndex, 7);
            int offsetX = this.random(random, maxOffset) + centerPos.method_10263();
            if (!world.method_8320(new class_2338(offsetX, offsetY = this.random(random, maxOffset) + centerPos.method_10264(), offsetZ = this.random(random, maxOffset) + centerPos.method_10260())).method_26225() || !this.isValidOreLocation(world, new class_2338(offsetX, offsetY, offsetZ), 1.0f, random)) continue;
            oreLocations.add(new class_243((double)offsetX, (double)offsetY, (double)offsetZ));
        }
        return oreLocations;
    }

    private int random(class_2919 random, int maxOffset) {
        return Math.round((random.method_43057() - random.method_43057()) * (float)maxOffset);
    }
}

