/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.donut;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2636;
import net.minecraft.class_2661;
import net.minecraft.class_2818;
import net.minecraft.class_3719;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.TickEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.module.setting.StringSetting;
import skid.gypsyy.utils.BlockUtil;
import skid.gypsyy.utils.EncryptedString;
import skid.gypsyy.utils.embed.DiscordWebhook;

public final class RTPEndBaseFinder
extends Module {
    private final NumberSetting minimumStorageCount = new NumberSetting(EncryptedString.of("Minimum Storage Count"), 1.0, 100.0, 4.0, 1.0).setDescription(EncryptedString.of("The minimum amount of storage blocks in a chunk to record the chunk (spawners ignore this limit)"));
    private final BooleanSetting criticalSpawner = new BooleanSetting(EncryptedString.of("Critical Spawner"), true).setDescription(EncryptedString.of("Mark chunk as stash even if only a single spawner is found"));
    private final NumberSetting rtpInterval = new NumberSetting(EncryptedString.of("RTP Interval"), 5.0, 60.0, 10.0, 1.0).setDescription(EncryptedString.of("Interval between RTP commands in seconds"));
    private final BooleanSetting disconnectOnBaseFind = new BooleanSetting(EncryptedString.of("Disconnect on Base Find"), true).setDescription(EncryptedString.of("Automatically disconnect when a base is found"));
    private final BooleanSetting lookDown = new BooleanSetting(EncryptedString.of("Look Down"), true).setDescription(EncryptedString.of("Automatically look down to avoid enderman aggro"));
    private final BooleanSetting sendNotifications = new BooleanSetting(EncryptedString.of("Notifications"), true).setDescription(EncryptedString.of("Sends Minecraft notifications when new stashes are found"));
    private final BooleanSetting enableWebhook = new BooleanSetting(EncryptedString.of("Webhook"), false).setDescription(EncryptedString.of("Send webhook notifications when stashes are found"));
    private final StringSetting webhookUrl = new StringSetting(EncryptedString.of("Webhook URL"), "").setDescription(EncryptedString.of("Discord webhook URL"));
    private final BooleanSetting selfPing = new BooleanSetting(EncryptedString.of("Self Ping"), false).setDescription(EncryptedString.of("Ping yourself in the webhook message"));
    private final StringSetting discordId = new StringSetting(EncryptedString.of("Discord ID"), "").setDescription(EncryptedString.of("Your Discord user ID for pinging"));
    private final NumberSetting scanInterval = new NumberSetting(EncryptedString.of("Scan Interval"), 1.0, 20.0, 5.0, 1.0).setDescription(EncryptedString.of("Interval between chunk scans in ticks (higher = less lag)"));
    private final NumberSetting maxChunksPerScan = new NumberSetting(EncryptedString.of("Max Chunks Per Scan"), 1.0, 10.0, 3.0, 1.0).setDescription(EncryptedString.of("Maximum chunks to scan per tick (lower = less lag)"));
    private final BooleanSetting enableSpawnerCheck = new BooleanSetting(EncryptedString.of("Enable Spawner Check"), true).setDescription(EncryptedString.of("Check for spawners (disable for maximum performance)"));
    public List<EndStashChunk> foundStashes = new ArrayList<EndStashChunk>();
    private final Set<class_1923> processedChunks = new HashSet<class_1923>();
    private long lastRtpTime = 0L;
    private Float originalPitch = null;
    private int scanTickCounter = 0;
    private final Queue<class_1923> chunksToScan = new LinkedList<class_1923>();
    private final Set<class_1923> chunksInQueue = new HashSet<class_1923>();
    private long lastPerformanceCheck = 0L;
    private int chunksScannedThisSecond = 0;

    public RTPEndBaseFinder() {
        super(EncryptedString.of("RTP End Base Finder"), EncryptedString.of("Continuously RTPs to the End and searches for stashes"), -1, Category.DONUT);
        this.addsettings(this.minimumStorageCount, this.criticalSpawner, this.rtpInterval, this.disconnectOnBaseFind, this.lookDown, this.sendNotifications, this.enableWebhook, this.webhookUrl, this.selfPing, this.discordId, this.scanInterval, this.maxChunksPerScan, this.enableSpawnerCheck);
    }

    @Override
    public void onEnable() {
        this.foundStashes.clear();
        this.processedChunks.clear();
        this.lastRtpTime = 0L;
        this.scanTickCounter = 0;
        this.chunksToScan.clear();
        this.chunksInQueue.clear();
        if (this.lookDown.getValue() && this.mc.field_1724 != null) {
            this.originalPitch = Float.valueOf(this.mc.field_1724.method_36455());
        }
        System.out.println("Started RTP End Base Finder");
    }

    @Override
    public void onDisable() {
        this.processedChunks.clear();
        this.chunksToScan.clear();
        this.chunksInQueue.clear();
        if (this.originalPitch != null && this.mc.field_1724 != null) {
            this.mc.field_1724.method_36457(this.originalPitch.floatValue());
            this.originalPitch = null;
        }
    }

    @EventListener
    public void onTick(TickEvent tickEvent) {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            long currentTime;
            if (this.lookDown.getValue()) {
                this.mc.field_1724.method_36457(90.0f);
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastRtpTime >= (long)this.rtpInterval.getIntValue() * 1000L) {
                this.mc.field_1724.field_3944.method_45730("rtp end");
                this.lastRtpTime = currentTime;
            }
            ++this.scanTickCounter;
            if (this.scanTickCounter >= this.scanInterval.getIntValue()) {
                this.scanTickCounter = 0;
                this.updateChunkQueue();
                this.scanQueuedChunks();
            }
        } else if (this.isEnabled()) {
            this.toggle();
        }
    }

    private void updateChunkQueue() {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            for (class_2818 worldChunk : BlockUtil.getLoadedChunks().toList()) {
                class_1923 chunkPos = worldChunk.method_12004();
                if (this.processedChunks.contains(chunkPos) || this.chunksInQueue.contains(chunkPos)) continue;
                this.chunksToScan.offer(chunkPos);
                this.chunksInQueue.add(chunkPos);
            }
        }
    }

    private void scanQueuedChunks() {
        int chunksScanned = 0;
        int maxChunks = this.maxChunksPerScan.getIntValue();
        while (!this.chunksToScan.isEmpty() && chunksScanned < maxChunks) {
            class_2818 worldChunk;
            class_1923 chunkPos = this.chunksToScan.poll();
            this.chunksInQueue.remove(chunkPos);
            if (chunkPos != null && this.mc.field_1687.method_8393(chunkPos.field_9181, chunkPos.field_9180) && (worldChunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180)) != null) {
                this.scanSingleChunk(worldChunk);
            }
            ++chunksScanned;
            ++this.chunksScannedThisSecond;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPerformanceCheck >= 1000L) {
            if (this.chunksScannedThisSecond > 0) {
                System.out.println("[RTPEndBaseFinder] Performance: " + this.chunksScannedThisSecond + " chunks scanned in last second");
            }
            this.chunksScannedThisSecond = 0;
            this.lastPerformanceCheck = currentTime;
        }
    }

    private void scanSingleChunk(class_2818 worldChunk) {
        class_1923 chunkPos = worldChunk.method_12004();
        if (!this.processedChunks.contains(chunkPos)) {
            EndStashChunk chunk = new EndStashChunk(chunkPos);
            boolean hasSpawner = false;
            if (this.enableSpawnerCheck.getValue()) {
                for (class_2586 blockEntity : worldChunk.method_12214().values()) {
                    if (!(blockEntity instanceof class_2636)) continue;
                    ++chunk.spawners;
                    hasSpawner = true;
                }
                if (!hasSpawner && this.criticalSpawner.getValue() && (hasSpawner = this.quickSpawnerCheck(worldChunk))) {
                    ++chunk.spawners;
                }
            }
            for (class_2586 blockEntityx : worldChunk.method_12214().values()) {
                class_2591 type = blockEntityx.method_11017();
                if (!this.isStorageBlock(type)) continue;
                if (blockEntityx instanceof class_2595) {
                    ++chunk.chests;
                    continue;
                }
                if (blockEntityx instanceof class_3719) {
                    ++chunk.barrels;
                    continue;
                }
                if (blockEntityx instanceof class_2627) {
                    ++chunk.shulkers;
                    continue;
                }
                if (blockEntityx instanceof class_2611) {
                    ++chunk.enderChests;
                    continue;
                }
                if (blockEntityx instanceof class_2609) {
                    ++chunk.furnaces;
                    continue;
                }
                if (blockEntityx instanceof class_2601) {
                    ++chunk.dispensersDroppers;
                    continue;
                }
                if (!(blockEntityx instanceof class_2614)) continue;
                ++chunk.hoppers;
            }
            boolean isStash = false;
            boolean isCriticalSpawner = false;
            Object detectionReason = "";
            if (this.criticalSpawner.getValue() && hasSpawner) {
                isStash = true;
                isCriticalSpawner = true;
                detectionReason = "Spawner(s) detected (Critical mode)";
            } else if (chunk.getTotalNonSpawner() >= this.minimumStorageCount.getIntValue()) {
                isStash = true;
                detectionReason = "Storage threshold reached (" + chunk.getTotalNonSpawner() + " blocks)";
            }
            if (isStash) {
                this.processedChunks.add(chunkPos);
                EndStashChunk prevChunk = null;
                int existingIndex = this.foundStashes.indexOf(chunk);
                if (existingIndex < 0) {
                    this.foundStashes.add(chunk);
                } else {
                    prevChunk = this.foundStashes.set(existingIndex, chunk);
                }
                if (!(!this.sendNotifications.getValue() || chunk.equals(prevChunk) && chunk.countsEqual(prevChunk))) {
                    String stashType = isCriticalSpawner ? "End spawner base" : "End stash";
                    System.out.println("Found " + stashType + " at " + chunk.x + ", " + chunk.z + ". " + (String)detectionReason);
                }
                if (!(!this.enableWebhook.getValue() || chunk.equals(prevChunk) && chunk.countsEqual(prevChunk))) {
                    this.sendWebhookNotification(chunk, isCriticalSpawner, (String)detectionReason);
                }
                if (this.disconnectOnBaseFind.getValue()) {
                    String stashTypeForDisconnect = isCriticalSpawner ? "End spawner base" : "End stash";
                    this.disconnectPlayer(stashTypeForDisconnect, chunk);
                }
            }
        }
    }

    private boolean quickSpawnerCheck(class_2818 worldChunk) {
        class_1923 chunkPos = worldChunk.method_12004();
        int xStart = chunkPos.method_8326();
        int zStart = chunkPos.method_8328();
        int[] checkY = new int[]{8, 16, 24, 32, 40, 48, 56, 64};
        int[] checkX = new int[]{2, 6, 10, 14};
        int[] checkZ = new int[]{2, 6, 10, 14};
        for (int y : checkY) {
            for (int x : checkX) {
                for (int z : checkZ) {
                    class_2338 pos = new class_2338(xStart + x, y, zStart + z);
                    try {
                        if (this.mc.field_1687.method_8320(pos).method_26204() != class_2246.field_10260) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    private boolean isStorageBlock(class_2591<?> type) {
        return type == class_2591.field_11914 || type == class_2591.field_16411 || type == class_2591.field_11896 || type == class_2591.field_11901 || type == class_2591.field_11903 || type == class_2591.field_16415 || type == class_2591.field_16414 || type == class_2591.field_11887 || type == class_2591.field_11899 || type == class_2591.field_11888;
    }

    private void disconnectPlayer(String stashType, EndStashChunk chunk) {
        System.out.println("Disconnecting due to " + stashType + " found at " + chunk.x + ", " + chunk.z);
        this.toggle();
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            if (this.mc.field_1724 != null) {
                this.mc.field_1724.field_3944.method_52781(new class_2661((class_2561)class_2561.method_43470((String)("END STASH FOUND AT " + chunk.x + ", " + chunk.z + "!"))));
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void sendWebhookNotification(EndStashChunk chunk, boolean isCriticalSpawner, String detectionReason) {
        String url = this.webhookUrl.getValue().trim();
        if (url.isEmpty()) {
            System.out.println("Webhook URL not configured!");
        } else {
            CompletableFuture.runAsync(() -> {
                try {
                    String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                    String messageContent = "";
                    if (this.selfPing.getValue() && !this.discordId.getValue().trim().isEmpty()) {
                        messageContent = String.format("<@%s>", this.discordId.getValue().trim());
                    }
                    String stashType = isCriticalSpawner ? "End Spawner Base" : "End Stash";
                    String description = String.format("%s found at End coordinates %d, %d!", stashType, chunk.x, chunk.z);
                    StringBuilder itemsFound = new StringBuilder();
                    int totalItems = 0;
                    if (chunk.chests > 0) {
                        itemsFound.append("Chests: ").append(chunk.chests).append("\\n");
                        totalItems += chunk.chests;
                    }
                    if (chunk.barrels > 0) {
                        itemsFound.append("Barrels: ").append(chunk.barrels).append("\\n");
                        totalItems += chunk.barrels;
                    }
                    if (chunk.shulkers > 0) {
                        itemsFound.append("Shulker Boxes: ").append(chunk.shulkers).append("\\n");
                        totalItems += chunk.shulkers;
                    }
                    if (chunk.enderChests > 0) {
                        itemsFound.append("Ender Chests: ").append(chunk.enderChests).append("\\n");
                        totalItems += chunk.enderChests;
                    }
                    if (chunk.furnaces > 0) {
                        itemsFound.append("Furnaces: ").append(chunk.furnaces).append("\\n");
                        totalItems += chunk.furnaces;
                    }
                    if (chunk.dispensersDroppers > 0) {
                        itemsFound.append("Dispensers/Droppers: ").append(chunk.dispensersDroppers).append("\\n");
                        totalItems += chunk.dispensersDroppers;
                    }
                    if (chunk.hoppers > 0) {
                        itemsFound.append("Hoppers: ").append(chunk.hoppers).append("\\n");
                        totalItems += chunk.hoppers;
                    }
                    if (isCriticalSpawner) {
                        itemsFound.append("Spawners: Present\\n");
                    }
                    DiscordWebhook webhook = new DiscordWebhook(url);
                    webhook.setUsername("RTP End-Stashfinder");
                    webhook.setAvatarUrl("https://imgur.com/a/21cFemF.png");
                    webhook.setContent(messageContent);
                    DiscordWebhook.EmbedObject embed = new DiscordWebhook.EmbedObject();
                    embed.setTitle("\ud83c\udf0c End Stashfinder Alert");
                    embed.setDescription(description);
                    embed.setColor(new Color(isCriticalSpawner ? 9830144 : 0x800080));
                    embed.addField("Detection Reason", detectionReason, false);
                    embed.addField("Total Items Found", String.valueOf(totalItems), false);
                    embed.addField("Items Breakdown", itemsFound.toString(), false);
                    embed.addField("End Coordinates", chunk.x + ", " + chunk.z, true);
                    embed.addField("Server", serverInfo, true);
                    embed.addField("Time", "<t:" + System.currentTimeMillis() / 1000L + ":R>", true);
                    embed.setFooter("RTP End-Stashfinder", null);
                    webhook.addEmbed(embed);
                    webhook.execute();
                    System.out.println("Webhook notification sent successfully");
                }
                catch (Throwable var13) {
                    System.out.println("Failed to send webhook: " + var13.getMessage());
                }
            });
        }
    }

    public static class EndStashChunk {
        public class_1923 chunkPos;
        public transient int x;
        public transient int z;
        public int chests;
        public int barrels;
        public int shulkers;
        public int enderChests;
        public int furnaces;
        public int dispensersDroppers;
        public int hoppers;
        public int spawners;

        public EndStashChunk(class_1923 chunkPos) {
            this.chunkPos = chunkPos;
            this.calculatePos();
        }

        public void calculatePos() {
            this.x = this.chunkPos.field_9181 * 16 + 8;
            this.z = this.chunkPos.field_9180 * 16 + 8;
        }

        public int getTotal() {
            return this.chests + this.barrels + this.shulkers + this.enderChests + this.furnaces + this.dispensersDroppers + this.hoppers + this.spawners;
        }

        public int getTotalNonSpawner() {
            return this.chests + this.barrels + this.shulkers + this.enderChests + this.furnaces + this.dispensersDroppers + this.hoppers;
        }

        public boolean countsEqual(EndStashChunk c) {
            return c == null ? false : this.chests == c.chests && this.barrels == c.barrels && this.shulkers == c.shulkers && this.enderChests == c.enderChests && this.furnaces == c.furnaces && this.dispensersDroppers == c.dispensersDroppers && this.hoppers == c.hoppers && this.spawners == c.spawners;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                EndStashChunk chunk = (EndStashChunk)o;
                return Objects.equals(this.chunkPos, chunk.chunkPos);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.chunkPos);
        }
    }
}

