/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.donut;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_2848;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.TickEvent;
import skid.gypsyy.mixin.PlayerInventoryAccessorMixin;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.module.setting.StringSetting;
import skid.gypsyy.utils.EncryptedString;

public final class SpawnerProtect
extends Module {
    private final NumberSetting detectionRadius = new NumberSetting(EncryptedString.of("Alpha"), 1.0, 32.0, 11.0, 1.0);
    private final NumberSetting breakDelay = new NumberSetting(EncryptedString.of("Alpha"), 1.0, 20.0, 5.0, 1.0);
    int silkTouchSlot = 0;
    private final String noSilkTouchMessage = "You Need To Have Silk Touch Pickaxe";
    private final String noSpawnersMessage = "No spawners found in detection range!";
    private final BooleanSetting enableWebhook = new BooleanSetting(EncryptedString.of("Discord Notification"), true);
    private final StringSetting webhookUrl = new StringSetting(EncryptedString.of("Webhook"), "");
    private List<class_2338> detectedSpawners = new ArrayList<class_2338>();
    private class_2338 currentTarget = null;
    private int breakingTicks = 0;
    private int silkTouchSlotIndex = -1;
    private int originalSlot = -1;
    private boolean isSneaking = false;
    private boolean isBreaking = false;
    private int delayTicks = 0;
    private boolean hasCheckedInitialRequirements = false;
    private boolean isBreakingBlock = false;
    private int breakProgress = 0;
    private boolean playerDetected = false;
    private String detectedPlayerName = null;

    public SpawnerProtect() {
        super(EncryptedString.of("Spawner Protetion"), EncryptedString.of("It breakes your spawners and puts them in the enderchest if player is nearby"), -1, Category.DONUT);
        this.addsettings(this.detectionRadius, this.breakDelay, this.enableWebhook, this.webhookUrl);
    }

    @Override
    public void onEnable() {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            this.detectedSpawners.clear();
            this.currentTarget = null;
            this.breakingTicks = 0;
            this.silkTouchSlotIndex = -1;
            this.originalSlot = -1;
            this.isSneaking = false;
            this.isBreaking = false;
            this.delayTicks = 0;
            this.hasCheckedInitialRequirements = false;
            this.isBreakingBlock = false;
            this.breakProgress = 0;
            this.playerDetected = false;
            this.detectedPlayerName = null;
            this.silkTouchSlotIndex = this.findSilkTouchPickaxe();
            if (this.silkTouchSlotIndex == -1) {
                Object kickMessage = new String("You Need To Have Silk Touch Pickaxe".getBytes());
                if (this.detectedPlayerName != null) {
                    kickMessage = "Player detected: " + this.detectedPlayerName;
                }
                this.kickPlayerAndDisable((String)kickMessage);
            } else {
                this.hasCheckedInitialRequirements = true;
                this.scanForSpawners();
            }
        } else {
            this.toggle();
        }
    }

    @Override
    public void onDisable() {
        if (this.isSneaking && this.mc.field_1724 != null) {
            this.mc.field_1724.method_5660(false);
            this.isSneaking = false;
        }
        if (this.isBreakingBlock && this.currentTarget != null) {
            this.mc.method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12971, this.currentTarget, class_2350.field_11036));
            this.isBreakingBlock = false;
        }
        if (this.originalSlot >= 0 && this.originalSlot < 9 && this.mc.field_1724 != null) {
            PlayerInventoryAccessorMixin inventoryAccessor = (PlayerInventoryAccessorMixin)this.mc.field_1724.method_31548();
            inventoryAccessor.setSelectedSlot(this.originalSlot);
        }
    }

    @EventListener
    private void onTick(TickEvent event) {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            if (!this.hasCheckedInitialRequirements) {
                if (!this.checkInitialRequirements()) {
                    return;
                }
                this.scanForSpawners();
                this.hasCheckedInitialRequirements = true;
            }
            if (this.delayTicks > 0) {
                --this.delayTicks;
            } else {
                boolean currentPlayerDetected = this.checkForOtherPlayers();
                if (!currentPlayerDetected) {
                    this.scanForSpawners();
                    this.playerDetected = false;
                    this.detectedPlayerName = null;
                    if (this.isSneaking) {
                        this.mc.field_1724.method_5660(false);
                        this.isSneaking = false;
                    }
                    if (this.isBreaking) {
                        this.isBreaking = false;
                        this.currentTarget = null;
                        if (this.isBreakingBlock) {
                            this.mc.method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12971, this.currentTarget, class_2350.field_11036));
                            this.isBreakingBlock = false;
                        }
                    }
                } else {
                    if (!this.playerDetected) {
                        this.playerDetected = true;
                    }
                    this.setSneaking(true);
                    if (this.detectedSpawners.isEmpty()) {
                        this.scanForSpawners();
                    }
                    if (this.detectedSpawners.isEmpty()) {
                        Object kickMessage = "No spawners to protect! Player detected but nothing to save.";
                        if (this.detectedPlayerName != null) {
                            kickMessage = (String)kickMessage + " | Player near: " + this.detectedPlayerName;
                        }
                        this.kickPlayerAndDisable((String)kickMessage);
                    } else {
                        PlayerInventoryAccessorMixin inventoryAccessor = (PlayerInventoryAccessorMixin)this.mc.field_1724.method_31548();
                        if (inventoryAccessor.getSelectedSlot() != this.silkTouchSlotIndex) {
                            this.originalSlot = inventoryAccessor.getSelectedSlot();
                            inventoryAccessor.setSelectedSlot(this.silkTouchSlotIndex);
                        }
                        this.processSpawnerBreaking();
                        if (this.detectedSpawners.isEmpty() && this.currentTarget == null) {
                            Object kickMessage = "All spawners have been protected! Disconnecting for safety.";
                            if (this.detectedPlayerName != null) {
                                kickMessage = (String)kickMessage + " | Player near: " + this.detectedPlayerName;
                            }
                            this.kickPlayerAndDisable((String)kickMessage);
                        }
                    }
                }
            }
        }
    }

    private void setSneaking(boolean sneak) {
        if (this.mc.field_1724 != null) {
            if (sneak) {
                this.mc.field_1724.method_5660(true);
                try {
                    this.mc.method_1562().method_52787((class_2596)new class_2848((class_1297)this.mc.field_1724, class_2848.class_2849.field_12979));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.mc.field_1690.field_1832.method_23481(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.isSneaking = true;
            } else if (!sneak && this.isSneaking) {
                this.mc.field_1724.method_5660(false);
                try {
                    this.mc.method_1562().method_52787((class_2596)new class_2848((class_1297)this.mc.field_1724, class_2848.class_2849.field_12984));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.mc.field_1690.field_1832.method_23481(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.isSneaking = false;
            }
        }
    }

    private boolean checkInitialRequirements() {
        this.silkTouchSlotIndex = this.findSilkTouchPickaxe();
        if (this.silkTouchSlotIndex == -1) {
            Object kickMessage = new String("You Need To Have Silk Touch Pickaxe".getBytes());
            if (this.detectedPlayerName != null) {
                kickMessage = (String)kickMessage + " | Player near: " + this.detectedPlayerName;
            }
            this.kickPlayerAndDisable((String)kickMessage);
            return false;
        }
        return true;
    }

    private int findSilkTouchPickaxe() {
        int manualSlot = this.silkTouchSlot;
        if (manualSlot >= 1 && manualSlot <= 9) {
            int slotIndex = manualSlot - 1;
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(slotIndex);
            return this.isPickaxe(stack) ? slotIndex : -1;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!this.isPickaxe(stack) || !stack.method_7942()) continue;
            String stackString = stack.toString().toLowerCase();
            if (!stackString.contains("silk_touch") && !stackString.contains("silktouch")) {
                try {
                    String displayName = stack.method_7964().getString().toLowerCase();
                    if (displayName.contains("silk") || displayName.contains("touch")) {
                        return i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return i;
            }
            return i;
        }
        return -1;
    }

    private boolean isPickaxe(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8647 || stack.method_7909() == class_1802.field_8387 || stack.method_7909() == class_1802.field_8403 || stack.method_7909() == class_1802.field_8335 || stack.method_7909() == class_1802.field_8377 || stack.method_7909() == class_1802.field_22024;
    }

    private boolean checkForOtherPlayers() {
        for (class_1657 player : this.mc.field_1687.method_18456()) {
            if (player == this.mc.field_1724 || player.method_31481()) continue;
            this.detectedPlayerName = player.method_5477().getString();
            String alertMessage = "Player detected nearby: " + this.detectedPlayerName;
            this.sendWebhookMessage(alertMessage);
            return true;
        }
        return false;
    }

    private void scanForSpawners() {
        this.detectedSpawners.clear();
        class_2338 playerPos = this.mc.field_1724.method_24515();
        int radius = this.detectionRadius.getIntValue();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = playerPos.method_10069(x, y, z);
                    if (this.mc.field_1687.method_8320(pos).method_26204() != class_2246.field_10260) continue;
                    this.detectedSpawners.add(pos);
                }
            }
        }
    }

    private void processSpawnerBreaking() {
        this.setSneaking(true);
        if (this.currentTarget == null) {
            if (this.detectedSpawners.isEmpty()) {
                return;
            }
            this.currentTarget = this.detectedSpawners.get(0);
            this.isBreaking = true;
            this.isBreakingBlock = false;
            this.breakingTicks = 0;
            this.breakProgress = 0;
        }
        if (this.mc.field_1687.method_8320(this.currentTarget).method_26204() != class_2246.field_10260) {
            this.detectedSpawners.remove(this.currentTarget);
            this.currentTarget = null;
            this.isBreaking = false;
            this.isBreakingBlock = false;
            this.breakProgress = 0;
            this.delayTicks = this.breakDelay.getIntValue();
        } else if (this.isBreaking) {
            this.breakSpawner(this.currentTarget);
            ++this.breakingTicks;
            if (this.breakingTicks > 200) {
                if (this.isBreakingBlock) {
                    this.mc.method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12971, this.currentTarget, class_2350.field_11036));
                    this.isBreakingBlock = false;
                }
                this.detectedSpawners.remove(this.currentTarget);
                this.currentTarget = null;
                this.isBreaking = false;
                this.breakProgress = 0;
                this.delayTicks = this.breakDelay.getIntValue();
            }
        }
    }

    private void breakSpawner(class_2338 pos) {
        this.setSneaking(true);
        class_243 blockCenter = class_243.method_24953((class_2382)pos);
        class_243 playerEyes = this.mc.field_1724.method_33571();
        class_243 direction = blockCenter.method_1020(playerEyes).method_1029();
        float yaw = (float)(Math.atan2(-direction.field_1352, direction.field_1350) * 180.0 / Math.PI);
        float pitch = (float)(Math.asin(-direction.field_1351) * 180.0 / Math.PI);
        this.mc.field_1724.method_36456(yaw);
        this.mc.field_1724.method_36457(pitch);
        class_2350 face = this.getClosestFace(pos, playerEyes);
        if (!this.isBreakingBlock) {
            this.mc.method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12968, pos, face));
            this.isBreakingBlock = true;
            this.breakProgress = 0;
        }
        ++this.breakProgress;
        this.mc.field_1724.method_6104(class_1268.field_5808);
        this.mc.field_1761.method_2902(pos, face);
        if (this.breakProgress >= 30) {
            this.mc.method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12973, pos, face));
            this.mc.field_1761.method_2910(pos, face);
            this.isBreakingBlock = false;
            this.breakProgress = 0;
        }
    }

    private class_2350 getClosestFace(class_2338 blockPos, class_243 playerEyes) {
        class_243 blockCenter = class_243.method_24953((class_2382)blockPos);
        class_243 diff = playerEyes.method_1020(blockCenter);
        double absX = Math.abs(diff.field_1352);
        double absY = Math.abs(diff.field_1351);
        double absZ = Math.abs(diff.field_1350);
        if (absX > absY && absX > absZ) {
            return diff.field_1352 > 0.0 ? class_2350.field_11034 : class_2350.field_11039;
        }
        if (absY > absZ) {
            return diff.field_1351 > 0.0 ? class_2350.field_11036 : class_2350.field_11033;
        }
        return diff.field_1350 > 0.0 ? class_2350.field_11035 : class_2350.field_11043;
    }

    private void kickPlayerAndDisable(String message) {
        this.toggle();
        if (this.enableWebhook.getValue() && !this.webhookUrl.getValue().isEmpty()) {
            this.sendWebhookMessage(message);
        }
        if (this.mc.method_1562() != null) {
            this.mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)message));
        } else if (this.mc.field_1687 != null) {
            this.mc.field_1687.method_8525();
        }
    }

    private void sendWebhookMessage(String message) {
        if (this.enableWebhook.getValue() && !this.webhookUrl.getValue().isEmpty()) {
            CompletableFuture.runAsync(() -> {
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    String jsonPayload = String.format("{\"content\":\"%s\"}", message.replace("\"", "\\\""));
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.webhookUrl.getValue())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
                    client.send(request, HttpResponse.BodyHandlers.ofString());
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            });
        }
    }
}

