/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.misc;

import java.util.List;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.TickEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.MacroSetting;
import skid.gypsyy.utils.EncryptedString;

public final class QuickMacro
extends Module {
    private final MacroSetting quickCommands = new MacroSetting(EncryptedString.of("Quick Commands")).setDescription(EncryptedString.of("Commands to execute when keybind is pressed"));
    private final BooleanSetting showNotifications = new BooleanSetting(EncryptedString.of("Show Notifications"), true).setDescription(EncryptedString.of("Show chat notifications when commands are executed"));
    private final BooleanSetting executeAll = new BooleanSetting(EncryptedString.of("Execute All"), false).setDescription(EncryptedString.of("Execute all commands or just the first one"));

    public QuickMacro() {
        super(EncryptedString.of("Quick Macro"), EncryptedString.of("\ud83d\udc31 Execute macro commands quickly with a keybind"), -1, Category.MISC);
        this.addsettings(this.quickCommands, this.showNotifications, this.executeAll);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.executeQuickMacro();
        this.toggle();
    }

    @Override
    public void onDisable() {
        super.onDisable();
    }

    @EventListener
    public void onTick(TickEvent event) {
    }

    private void executeQuickMacro() {
        if (this.mc.field_1724 != null && this.mc.method_1562() != null) {
            List<String> commandList = this.quickCommands.getCommands();
            if (commandList.isEmpty()) {
                if (this.showNotifications.getValue()) {
                    this.mc.field_1724.method_43496(EncryptedString.of("\u00a7c\ud83d\udc31 Quick Macro: No commands configured!").toText());
                }
            } else if (this.executeAll.getValue()) {
                for (int i = 0; i < commandList.size(); ++i) {
                    String command = commandList.get(i);
                    this.executeCommand(command);
                    if (!this.showNotifications.getValue()) continue;
                    this.mc.field_1724.method_43496(EncryptedString.of("\u00a7e\ud83d\udc31 Quick Macro: Executed command " + (i + 1) + "/" + commandList.size()).toText());
                }
                if (this.showNotifications.getValue()) {
                    this.mc.field_1724.method_43496(EncryptedString.of("\u00a7a\ud83d\udc31 Quick Macro: All commands executed!").toText());
                }
            } else {
                String command = commandList.get(0);
                this.executeCommand(command);
                if (this.showNotifications.getValue()) {
                    this.mc.field_1724.method_43496(EncryptedString.of("\u00a7a\ud83d\udc31 Quick Macro: Executed command!").toText());
                }
            }
        }
    }

    private void executeCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
            this.mc.method_1562().method_45730(command);
        } else {
            this.mc.method_1562().method_45729(command);
        }
    }
}

