/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.render;

import java.awt.Color;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.ChunkDataEvent;
import skid.gypsyy.event.events.Render3DEvent;
import skid.gypsyy.event.events.TickEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BlocksSetting;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.utils.BlockUtil;
import skid.gypsyy.utils.EncryptedString;
import skid.gypsyy.utils.RenderUtils;

public final class BlockEsp
extends Module {
    public static BlockEsp instance;
    private final BlocksSetting blocks = new BlocksSetting((CharSequence)EncryptedString.of("Blocks"), new class_2248[0]);
    private final BooleanSetting tracers = new BooleanSetting(EncryptedString.of("Tracers"), true);
    private final NumberSetting alpha = new NumberSetting(EncryptedString.of("Alpha"), 1.0, 255.0, 125.0, 1.0);
    private final NumberSetting red = new NumberSetting(EncryptedString.of("Red"), 0.0, 255.0, 255.0, 1.0);
    private final NumberSetting green = new NumberSetting(EncryptedString.of("Green"), 0.0, 255.0, 0.0, 1.0);
    private final NumberSetting blue = new NumberSetting(EncryptedString.of("Blue"), 0.0, 255.0, 0.0, 1.0);
    private final ConcurrentHashMap<Long, Set<class_2338>> cachedBlocks = new ConcurrentHashMap();
    private final ExecutorService executor = Executors.newFixedThreadPool(3);
    private final Set<Long> scanningChunks = ConcurrentHashMap.newKeySet();
    private volatile boolean needsRescan = false;
    private int tickCounter = 0;

    public BlockEsp() {
        super(EncryptedString.of("Block Esp"), EncryptedString.of("Highlights selected blocks through walls"), -1, Category.RENDER);
        this.addsettings(this.blocks, this.tracers, this.alpha, this.red, this.green, this.blue);
        instance = this;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.cachedBlocks.clear();
        this.scanningChunks.clear();
        this.needsRescan = true;
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.cachedBlocks.clear();
        this.scanningChunks.clear();
    }

    public static BlockEsp getInstance() {
        if (instance == null) {
            instance = new BlockEsp();
        }
        return instance;
    }

    @EventListener
    public void onTick(TickEvent event) {
        if (this.mc.field_1687 != null && this.blocks.size() != 0) {
            ++this.tickCounter;
            if (this.needsRescan || this.tickCounter % 100 == 0) {
                this.needsRescan = false;
                this.scanAllChunks();
            }
        }
    }

    @EventListener
    public void onChunkData(ChunkDataEvent event) {
        if (event.getChunk() instanceof class_2818) {
            this.scanChunk((class_2818)event.getChunk());
        }
    }

    private void scanAllChunks() {
        if (this.mc.field_1687 != null) {
            for (class_2818 chunk : BlockUtil.getLoadedChunks().toList()) {
                this.scanChunk(chunk);
            }
        }
    }

    private void scanChunk(class_2818 chunk) {
        long chunkKey;
        if (chunk != null && this.blocks.size() != 0 && this.scanningChunks.add(chunkKey = chunk.method_12004().method_8324())) {
            this.executor.submit(() -> {
                try {
                    ConcurrentHashMap.KeySetView foundBlocks = ConcurrentHashMap.newKeySet();
                    class_1923 chunkPos = chunk.method_12004();
                    int startX = chunkPos.method_8326();
                    int startZ = chunkPos.method_8328();
                    class_2826[] sections = chunk.method_12006();
                    int minSection = this.mc.field_1687.method_32891();
                    for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
                        class_2826 section = sections[sectionIndex];
                        if (section == null || section.method_38292()) continue;
                        int sectionY = (minSection + sectionIndex) * 16;
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                for (int y = 0; y < 16; ++y) {
                                    class_2680 state = section.method_12254(x, y, z);
                                    if (!this.blocks.contains(state.method_26204())) continue;
                                    class_2338 pos = new class_2338(startX + x, sectionY + y, startZ + z);
                                    foundBlocks.add(pos);
                                }
                            }
                        }
                    }
                    if (foundBlocks.isEmpty()) {
                        this.cachedBlocks.remove(chunkKey);
                    } else {
                        this.cachedBlocks.put(chunkKey, foundBlocks);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.scanningChunks.remove(chunkKey);
                }
            });
        }
    }

    @EventListener
    public void onRender3D(Render3DEvent event) {
        if (this.blocks.size() != 0 && !this.cachedBlocks.isEmpty()) {
            class_4184 cam = this.mc.field_1773.method_19418();
            if (cam == null) {
                return;
            }
            class_243 camPos = cam.method_19326();
            class_4587 matrices = event.matrixStack;
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(cam.method_19329()));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(cam.method_19330() + 180.0f));
            matrices.method_22904(0.0, -camPos.field_1351, 0.0);
            Color blockColor = new Color(this.red.getIntValue(), this.green.getIntValue(), this.blue.getIntValue(), this.alpha.getIntValue());
            Color tracerColor = new Color(this.red.getIntValue(), this.green.getIntValue(), this.blue.getIntValue(), 255);
            for (Set<class_2338> blockSet : this.cachedBlocks.values()) {
                if (blockSet == null) continue;
                for (class_2338 blockPos : blockSet) {
                    double distSq;
                    if (blockPos == null || (distSq = this.mc.field_1724.method_5649((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5)) > 10000.0) continue;
                    RenderUtils.drawFilledBox(matrices, (float)blockPos.method_10263() + 0.1f, (float)blockPos.method_10264() + 0.05f, (float)blockPos.method_10260() + 0.1f, (float)blockPos.method_10263() + 0.9f, (float)blockPos.method_10264() + 0.85f, (float)blockPos.method_10260() + 0.9f, blockColor);
                    if (!this.tracers.getValue()) continue;
                    tracerColor = new Color(this.red.getIntValue(), this.green.getIntValue(), this.blue.getIntValue(), 255);
                    class_243 lookVec = class_243.method_1030((float)cam.method_19329(), (float)cam.method_19330());
                    class_243 startPos = camPos.method_1019(lookVec.method_1021(0.1));
                    class_243 endPos = new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
                    RenderUtils.drawLine(startPos, endPos, tracerColor, matrices);
                }
            }
            matrices.method_22909();
        }
    }
}

