/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.render;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2393;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.Render3DEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.utils.EncryptedString;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.Timer;

public final class KelpESP
extends Module {
    private final NumberSetting range = new NumberSetting(EncryptedString.of("Range"), 10.0, 100.0, 50.0, 1.0);
    private final NumberSetting scanDelay = new NumberSetting(EncryptedString.of("Scan Delay"), 1.0, 20.0, 10.0, 1.0);
    private final NumberSetting alpha = new NumberSetting(EncryptedString.of("Alpha"), 50.0, 255.0, 150.0, 1.0);
    private final BooleanSetting showHeight = new BooleanSetting(EncryptedString.of("Show Height"), true).setDescription(EncryptedString.of("Shows the height of the kelp"));
    private final BooleanSetting onlyTallest = new BooleanSetting(EncryptedString.of("Only Tallest"), true).setDescription(EncryptedString.of("Only highlights the tallest kelp in each cluster"));
    private final BooleanSetting onlySurfaceKelp = new BooleanSetting(EncryptedString.of("Only Surface Kelp"), true).setDescription(EncryptedString.of("Only highlights kelp that reaches the water surface"));
    private final NumberSetting minSurfaceHeight = new NumberSetting(EncryptedString.of("Min Surface Height"), 1.0, 20.0, 3.0, 1.0).setDescription(EncryptedString.of("Minimum height for kelp to be considered surface-reaching"));
    private final Map<class_2338, Integer> kelpHeights = new HashMap<class_2338, Integer>();
    private final Map<class_2338, Integer> waterSurfaceLevels = new HashMap<class_2338, Integer>();
    private final Set<class_2338> processedClusters = new HashSet<class_2338>();
    private final Timer scanTimer = new Timer();

    public KelpESP() {
        super(EncryptedString.of("Kelp ESP"), EncryptedString.of("Highlights kelp that reaches the water surface for base finding"), -1, Category.RENDER);
        this.range.setDescription(EncryptedString.of("Range to search for kelp"));
        this.alpha.setDescription(EncryptedString.of("Transparency of the ESP"));
        this.scanDelay.setDescription(EncryptedString.of("Delay between kelp scans in ticks."));
        this.addsettings(this.range, this.alpha, this.showHeight, this.onlyTallest, this.onlySurfaceKelp, this.minSurfaceHeight, this.scanDelay);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.kelpHeights.clear();
        this.waterSurfaceLevels.clear();
        this.processedClusters.clear();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.kelpHeights.clear();
        this.waterSurfaceLevels.clear();
        this.processedClusters.clear();
    }

    @EventListener
    public void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            class_4184 cam;
            if (this.scanTimer.passedMs((long)this.scanDelay.getIntValue() * 50L)) {
                this.scanForKelp();
                this.scanTimer.reset();
            }
            if ((cam = RenderUtils.getCamera()) != null) {
                class_243 camPos = RenderUtils.getCameraPos();
                class_4587 matrices = event.matrixStack;
                matrices.method_22903();
                matrices.method_22907(class_7833.field_40714.rotationDegrees(cam.method_19329()));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(cam.method_19330() + 180.0f));
                matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
            }
            for (Map.Entry<class_2338, Integer> entry : this.kelpHeights.entrySet()) {
                class_2338 pos = entry.getKey();
                int height = entry.getValue();
                if (this.onlySurfaceKelp.getValue() && !this.reachesWaterSurface(pos, height) || this.onlyTallest.getValue() && !this.isTallestInCluster(pos, height)) continue;
                Color color = this.getKelpColor(height);
                RenderUtils.renderFilledBox(event.matrixStack, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, color);
                RenderUtils.renderLine(event.matrixStack, color, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), new class_243((double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1)));
                if (!this.showHeight.getValue()) continue;
                String heightText = String.valueOf(height);
                new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5);
            }
            event.matrixStack.method_22909();
        }
    }

    private void scanForKelp() {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            this.kelpHeights.clear();
            this.waterSurfaceLevels.clear();
            this.processedClusters.clear();
            class_2338 playerPos = this.mc.field_1724.method_24515();
            int range = this.range.getIntValue();
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    for (int y = -20; y <= 20; ++y) {
                        int height;
                        class_2338 pos = playerPos.method_10069(x, y, z);
                        class_2680 state = this.mc.field_1687.method_8320(pos);
                        if (!(state.method_26204() instanceof class_2393) || (height = this.getKelpHeight(pos, state)) <= 0) continue;
                        this.kelpHeights.put(pos, height);
                        int surfaceLevel = this.findWaterSurfaceLevel(pos);
                        this.waterSurfaceLevels.put(pos, surfaceLevel);
                    }
                }
            }
        }
    }

    private int getKelpHeight(class_2338 pos, class_2680 initialBlockState) {
        if (this.mc.field_1687 == null) {
            return 0;
        }
        int height = 0;
        class_2338 currentPos = pos;
        if (!(initialBlockState.method_26204() instanceof class_2393)) {
            return 0;
        }
        while (this.mc.field_1687.method_8320(currentPos).method_26204() instanceof class_2393) {
            currentPos = currentPos.method_10084();
            if (++height <= 25) continue;
            break;
        }
        return height;
    }

    private int findWaterSurfaceLevel(class_2338 kelpBase) {
        if (this.mc.field_1687 == null) {
            return kelpBase.method_10264();
        }
        class_2338 currentPos = kelpBase;
        while (currentPos.method_10264() < 320) {
            class_2680 state = this.mc.field_1687.method_8320(currentPos);
            if (state.method_26215()) {
                return currentPos.method_10264();
            }
            if (!state.method_26227().method_15769() && !(state.method_26204() instanceof class_2393) && state.method_26204() != class_2246.field_10376 && state.method_26204() != class_2246.field_10238) {
                return currentPos.method_10264();
            }
            currentPos = currentPos.method_10084();
        }
        return kelpBase.method_10264();
    }

    private boolean reachesWaterSurface(class_2338 kelpBase, int kelpHeight) {
        Integer surfaceLevel = this.waterSurfaceLevels.get(kelpBase);
        if (surfaceLevel == null) {
            return false;
        }
        int kelpTop = kelpBase.method_10264() + kelpHeight - 1;
        boolean reachesSurface = kelpTop >= surfaceLevel - 1;
        boolean meetsMinHeight = kelpHeight >= this.minSurfaceHeight.getIntValue();
        return reachesSurface && meetsMinHeight;
    }

    private boolean isTallestInCluster(class_2338 pos, int height) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                class_2338 checkPos = pos.method_10069(x, 0, z);
                Integer checkHeight = this.kelpHeights.get(checkPos);
                if (checkHeight == null || checkHeight <= height) continue;
                return false;
            }
        }
        return true;
    }

    private Color getKelpColor(int height) {
        int blue;
        int green;
        int red;
        if (height <= 5) {
            red = 0;
            green = 255;
            blue = 0;
        } else if (height <= 10) {
            red = 255;
            green = 255;
            blue = 0;
        } else if (height <= 15) {
            red = 255;
            green = 165;
            blue = 0;
        } else {
            red = 255;
            green = 0;
            blue = 0;
        }
        return new Color(red, green, blue, this.alpha.getIntValue());
    }
}

