/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.render;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8646;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.TickEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.StringSetting;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.EncryptedString;
import skid.gypsyy.utils.PingUtil;

public final class ScoreboardModule
extends Module {
    private static final String OBJECTIVE_NAME = "gypsyy_scoreboard";
    private class_266 customObjective;
    private class_266 originalObjective;
    private boolean wasEnabled = false;
    private final StringSetting Money = new StringSetting(EncryptedString.of("Money"), "36M");
    private final StringSetting Shards = new StringSetting(EncryptedString.of("Shards"), "36");
    private final StringSetting Kills = new StringSetting(EncryptedString.of("Kills"), "36");
    private final StringSetting Deaths = new StringSetting(EncryptedString.of("Deaths"), "36");
    private final StringSetting Keyall = new StringSetting(EncryptedString.of("Key All"), "3m 6s");
    private final StringSetting Playtime = new StringSetting(EncryptedString.of("Playtime"), "3h 6m");
    private final StringSetting Team = new StringSetting(EncryptedString.of("Team"), "BambooClient");
    private final StringSetting Title = new StringSetting(EncryptedString.of("Title"), "Protected by Bamboo");
    private final StringSetting Region = new StringSetting(EncryptedString.of("Region"), "https://discord.gg/4KupTRetPv");
    private final Boolean enabled = true;

    public ScoreboardModule() {
        super(EncryptedString.of("Fake Stats"), EncryptedString.of("Custom scoreboard overlay"), -1, Category.RENDER);
        this.addsettings(this.Money, this.Shards, this.Kills, this.Deaths, this.Keyall, this.Playtime, this.Team, this.Title, this.Region);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.wasEnabled = true;
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.restoreOriginalScoreboard();
        this.wasEnabled = false;
    }

    @EventListener
    public void onTick(TickEvent event) {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            if (this.enabled.booleanValue() && this.isEnabled()) {
                this.updateCustomScoreboard();
            } else if (this.wasEnabled) {
                this.restoreOriginalScoreboard();
                this.wasEnabled = false;
            }
        }
    }

    private void updateCustomScoreboard() {
        class_269 scoreboard = this.mc.field_1687.method_8428();
        if (this.originalObjective == null) {
            this.originalObjective = scoreboard.method_1189(class_8646.field_45157);
        }
        if (this.customObjective == null) {
            class_266 existing = scoreboard.method_1170(OBJECTIVE_NAME);
            if (existing != null) {
                scoreboard.method_1194(existing);
            }
            this.customObjective = scoreboard.method_1168(OBJECTIVE_NAME, class_274.field_1468, this.parseGradientText("  Protected by krispyy  ", "#007CF9", "#00C6F9"), class_274.class_275.field_1472, true, null);
        }
        scoreboard.method_1158(class_8646.field_45157, this.customObjective);
        scoreboard.method_1194(this.customObjective);
        this.customObjective = scoreboard.method_1168(OBJECTIVE_NAME, class_274.field_1468, this.parseGradientText("  Protected by krispyy  ", "#007CF9", "#00C6F9"), class_274.class_275.field_1472, true, null);
        scoreboard.method_1158(class_8646.field_45157, this.customObjective);
        List<class_2561> lines = this.getScoreboardLines();
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 lineText = lines.get(i);
            String invisibleId = "\u00a7" + i + "\u00a7r";
            class_9015 holder = class_9015.method_55422((String)invisibleId);
            class_9014 score = scoreboard.method_1180(holder, this.customObjective);
            score.method_55410(lines.size() - i);
            score.method_55411(lineText);
        }
        String Formatedtitle = "   " + this.Title.getValue() + "   ";
        this.customObjective.method_1121(this.parseGradientText(Formatedtitle, "#007CF9", "#00C6F9"));
    }

    private List<class_2561> getScoreboardLines() {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add((class_2561)class_2561.method_43470((String)" "));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"$ ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)64512)).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"Money ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFFFF)))).method_10852((class_2561)class_2561.method_43470((String)this.Money.getValue()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)64512)))));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\u2605 ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)10683385)))).method_10852((class_2561)class_2561.method_43470((String)"Shards ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFFFF)))).method_10852((class_2561)class_2561.method_43470((String)this.Shards.getValue()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)10683385)))));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udde1 ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFC0000)))).method_10852((class_2561)class_2561.method_43470((String)"Kills ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFFFF)))).method_10852((class_2561)class_2561.method_43470((String)this.Kills.getValue()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFC0000)))));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\u2620 ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)16348675)))).method_10852((class_2561)class_2561.method_43470((String)"Deaths ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFFFF)))).method_10852((class_2561)class_2561.method_43470((String)this.Deaths.getValue()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)16348675)))));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\u231b ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)42236)))).method_10852((class_2561)class_2561.method_43470((String)"Keyall ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFFFF)))).method_10852((class_2561)class_2561.method_43470((String)this.Keyall.getValue()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)42236)))));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\u231a ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)16573184)))).method_10852((class_2561)class_2561.method_43470((String)"Playtime ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFFFF)))).method_10852((class_2561)class_2561.method_43470((String)this.Playtime.getValue()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)16573184)))));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\ud83e\ude93 ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)42236)))).method_10852((class_2561)class_2561.method_43470((String)"Team ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFFFF)))).method_10852((class_2561)class_2561.method_43470((String)this.Team.getValue()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)42236)))));
        lines.add((class_2561)class_2561.method_43470((String)" "));
        lines.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.Region.getValue() + " (")).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA8A8A8)))).method_10852((class_2561)class_2561.method_43470((String)PingUtil.getPingString().toString()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)42236)))).method_10852((class_2561)class_2561.method_43470((String)")").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA8A8A8)))));
        return lines;
    }

    private void restoreOriginalScoreboard() {
        if (this.mc.field_1687 != null) {
            class_269 scoreboard = this.mc.field_1687.method_8428();
            if (this.customObjective != null) {
                scoreboard.method_1194(this.customObjective);
                this.customObjective = null;
            }
            if (this.originalObjective != null) {
                scoreboard.method_1158(class_8646.field_45157, this.originalObjective);
                this.originalObjective = null;
            }
        }
    }

    private class_2561 parseGradientText(String text, String startHex, String endHex) {
        if (text.isEmpty()) {
            return class_2561.method_43470((String)"");
        }
        Color startColor = Color.decode(startHex);
        Color endColor = Color.decode(endHex);
        class_5250 result = class_2561.method_43470((String)"");
        for (int i = 0; i < text.length(); ++i) {
            float progress = text.length() > 1 ? (float)i / (float)(text.length() - 1) : 0.0f;
            Color interpolated = ColorUtil.keyCodec(startColor, endColor, progress);
            int rgb = interpolated.getRed() << 16 | interpolated.getGreen() << 8 | interpolated.getBlue();
            result.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb)).method_10982(Boolean.valueOf(true))));
        }
        return result;
    }

    private String formatColoredText(String text, String hex) {
        Color color = Color.decode(hex);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            result.append(this.formatMinecraftColor(color));
            result.append(text.charAt(i));
        }
        return result.toString();
    }

    private String formatMinecraftColor(Color color) {
        String hex = String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        StringBuilder result = new StringBuilder("\u00a7x");
        for (char c : hex.toCharArray()) {
            result.append("\u00a7").append(c);
        }
        return result.toString();
    }
}

