/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.render;

import java.awt.Color;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2824;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.PacketSendEvent;
import skid.gypsyy.event.events.Render2DEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.utils.ColorUtil;
import skid.gypsyy.utils.EncryptedString;
import skid.gypsyy.utils.MathUtil;
import skid.gypsyy.utils.RenderUtils;
import skid.gypsyy.utils.TextRenderer;

public final class TargetHUD
extends Module {
    private final NumberSetting xPosition = new NumberSetting(EncryptedString.of("X"), 0.0, 1920.0, 500.0, 1.0);
    private final NumberSetting yPosition = new NumberSetting(EncryptedString.of("Y"), 0.0, 1080.0, 500.0, 1.0);
    private final BooleanSetting timeoutEnabled = new BooleanSetting(EncryptedString.of("Timeout"), true).setDescription(EncryptedString.of("Target hud will disappear after 10 seconds"));
    private final NumberSetting fadeSpeed = new NumberSetting(EncryptedString.of("Fade Speed"), 5.0, 30.0, 15.0, 1.0).getValue(EncryptedString.of("Speed of animations"));
    private final Color primaryColor = new Color(255, 50, 100);
    private final Color backgroundColor = new Color(0, 0, 0, 175);
    private long lastAttackTime = 0L;
    public static float fadeProgress = 1.0f;
    private float currentHealth = 0.0f;
    private TargetHUDHandler hudHandler;

    public TargetHUD() {
        super(EncryptedString.of("Target HUD"), EncryptedString.of("Displays detailed information about your target with style"), -1, Category.RENDER);
        this.addsettings(this.xPosition, this.yPosition, this.timeoutEnabled, this.fadeSpeed);
    }

    @Override
    public void onEnable() {
        super.onEnable();
    }

    @Override
    public void onDisable() {
        super.onDisable();
    }

    @EventListener
    public void onRender2D(Render2DEvent render2DEvent) {
        class_332 drawContext = render2DEvent.context;
        int xPos = this.xPosition.getIntValue();
        int yPos = this.yPosition.getIntValue();
        float fadeSpeed = this.fadeSpeed.getFloatValue();
        Color primaryColor = this.primaryColor;
        Color backgroundColor = this.backgroundColor;
        RenderUtils.unscaledProjection();
        boolean hasTarget = this.mc.field_1724.method_6052() != null && this.mc.field_1724.method_6052() instanceof class_1657 && this.mc.field_1724.method_6052().method_5805();
        boolean notTimedOut = !this.timeoutEnabled.getValue() || System.currentTimeMillis() - this.lastAttackTime <= 10000L;
        float targetFade = hasTarget && notTimedOut ? 0.0f : 1.0f;
        fadeProgress = RenderUtils.fast(fadeProgress, targetFade, fadeSpeed);
        if (fadeProgress < 0.99f && hasTarget) {
            class_1309 target = this.mc.field_1724.method_6052();
            class_640 playerListEntry = this.mc.method_1562().method_2871(target.method_5667());
            class_4587 matrices = drawContext.method_51448();
            matrices.method_22903();
            float fadeAmount = 1.0f - fadeProgress;
            float scaleAmount = 0.8f + 0.2f * fadeAmount;
            matrices.method_46416((float)xPos, (float)yPos, 0.0f);
            matrices.method_22905(scaleAmount, scaleAmount, 1.0f);
            matrices.method_46416((float)(-xPos), (float)(-yPos), 0.0f);
            this.currentHealth = RenderUtils.fast(this.currentHealth, target.method_6032() + target.method_6067(), fadeSpeed * 0.5f);
            this.keyCodec(drawContext, xPos, yPos, (class_1657)target, playerListEntry, fadeAmount, primaryColor, backgroundColor);
            matrices.method_22909();
        }
        RenderUtils.scaledProjection();
    }

    private void keyCodec(class_332 drawContext, int n, int n2, class_1657 playerEntity, class_640 playerListEntry, float n3, Color color, Color color2) {
        class_4587 matrices = drawContext.method_51448();
        RenderUtils.renderRoundedQuad(matrices, new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(50.0f * n3)), n - 5, n2 - 5, n + 300 + 5, n2 + 180 + 5, 15.0, 15.0, 15.0, 15.0, 30.0);
        RenderUtils.renderRoundedQuad(matrices, new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)((float)color2.getAlpha() * n3)), n, n2, n + 300, n2 + 180, 10.0, 10.0, 10.0, 10.0, 20.0);
        Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * n3));
        RenderUtils.renderRoundedQuad(matrices, color3, n + 20, n2, n + 300 - 20, n2 + 3, 0.0, 0.0, 0.0, 0.0, 10.0);
        RenderUtils.renderRoundedQuad(matrices, color3, n + 20, n2 + 180 - 3, n + 300 - 20, n2 + 180, 0.0, 0.0, 0.0, 0.0, 10.0);
        if (playerListEntry != null) {
            RenderUtils.renderRoundedQuad(matrices, new Color(30, 30, 30, (int)(200.0f * n3)), n + 15, n2 + 15, n + 85, n2 + 85, 5.0, 5.0, 5.0, 5.0, 10.0);
            class_7532.method_44443((class_332)drawContext, (class_2960)playerListEntry.method_52810().comp_1626(), (int)(n + 25), (int)(n2 + 25), (int)50);
            TextRenderer.drawString(playerEntity.method_5477().getString(), drawContext, n + 100, n2 + 25, ColorUtil.keyCodec((int)((float)(System.currentTimeMillis() % 1000L) / 1000.0f), 1).getRGB());
            TextRenderer.drawString(MathUtil.roundToNearest(playerEntity.method_5739((class_1297)this.mc.field_1724), 1.0) + " blocks away", drawContext, n + 100, n2 + 45, Color.WHITE.getRGB());
            RenderUtils.renderRoundedQuad(matrices, new Color(60, 60, 60, (int)(200.0f * n3)), n + 15, n2 + 95, n + 300 - 15, n2 + 110, 5.0, 5.0, 5.0, 5.0, 10.0);
            float b = this.currentHealth / playerEntity.method_6063();
            float n4 = 270.0f * Math.min(1.0f, b);
            RenderUtils.renderRoundedQuad(matrices, this.keyCodec(b * (float)((double)0.8f + (double)0.2f * Math.sin((double)System.currentTimeMillis() / 300.0)), n3), n + 15, n2 + 95, n + 15 + (int)n4, n2 + 110, 5.0, 5.0, 5.0, 5.0, 10.0);
            String s = Math.round(this.currentHealth) + "/" + Math.round(playerEntity.method_6063()) + " HP";
            TextRenderer.drawString(s, drawContext, n + 15 + (int)n4 / 2 - TextRenderer.getWidth(s) / 2, n2 + 95, Color.WHITE.getRGB());
            int n5 = n2 + 120;
            this.keyCodec(drawContext, n + 15, n5, 80, 45, "PING", playerListEntry.method_2959() + "ms", this.keyCodec(playerListEntry.method_2959(), n3), color3, n3);
            String s2 = playerListEntry != null ? "PLAYER" : "BOT";
            Color color4 = playerListEntry != null ? new Color(100, 255, 100, (int)(255.0f * n3)) : new Color(255, 100, 100, (int)(255.0f * n3));
            this.keyCodec(drawContext, n + 100 + 5, n5, 80, 45, "TYPE", s2, color4, color3, n3);
            if (playerEntity.field_6235 > 0) {
                this.keyCodec(drawContext, n + 200 + 5, n5, 80, 45, "HURT", "" + playerEntity.field_6235, this.elementCodec(playerEntity.field_6235, n3), color3, n3);
            } else {
                this.keyCodec(drawContext, n + 200 + 5, n5, 80, 45, "HURT", "No", new Color(150, 150, 150, (int)(255.0f * n3)), color3, n3);
            }
        } else {
            TextRenderer.drawString("BOT DETECTED", drawContext, n + 150 - TextRenderer.getWidth("BOT DETECTED") / 2, n2 + 90, new Color(255, 50, 50).getRGB());
        }
    }

    private void keyCodec(class_332 drawContext, int n, int n2, int n3, int n4, String s, String s2, Color color, Color color2, float n5) {
        class_4587 matrices = drawContext.method_51448();
        RenderUtils.renderRoundedQuad(matrices, color2, n, n2, n + n3, n2 + 3, 3.0, 3.0, 0.0, 0.0, 6.0);
        RenderUtils.renderRoundedQuad(matrices, new Color(30, 30, 30, (int)(200.0f * n5)), n, n2 + 3, n + n3, n2 + n4, 0.0, 0.0, 3.0, 3.0, 6.0);
        TextRenderer.drawString(s, drawContext, n + n3 / 2 - TextRenderer.getWidth(s) / 2, n2 + 5, new Color(200, 200, 200, (int)(255.0f * n5)).getRGB());
        TextRenderer.drawString(s2, drawContext, n + n3 / 2 - TextRenderer.getWidth(s2) / 2, n2 + n4 - 17, color.getRGB());
    }

    private Color keyCodec(float n, float n2) {
        Color color;
        if (n > 0.75f) {
            color = ColorUtil.keyCodec(new Color(100, 255, 100), new Color(255, 255, 100), (1.0f - n) * 4.0f);
        } else if (n > 0.25f) {
            color = ColorUtil.keyCodec(new Color(255, 255, 100), new Color(255, 100, 100), (0.75f - n) * 2.0f);
        } else {
            float n3 = n < 0.1f ? (float)((double)0.7f + (double)0.3f * Math.sin((double)System.currentTimeMillis() / 200.0)) : 1.0f;
            color = new Color((int)(255.0f * n3), (int)(100.0f * n3), (int)(100.0f * n3));
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * n2));
    }

    private Color keyCodec(int n, float n2) {
        Color color = n < 50 ? new Color(100, 255, 100) : (n < 100 ? ColorUtil.keyCodec(new Color(100, 255, 100), new Color(255, 255, 100), (float)(n - 50) / 50.0f) : (n < 200 ? ColorUtil.keyCodec(new Color(255, 255, 100), new Color(255, 150, 50), (float)(n - 100) / 100.0f) : ColorUtil.keyCodec(new Color(255, 150, 50), new Color(255, 80, 80), Math.min(1.0f, (float)(n - 200) / 300.0f))));
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * n2));
    }

    private Color elementCodec(int n, float n2) {
        double n3 = (double)0.7f + (double)0.3f * Math.sin((double)System.currentTimeMillis() / 150.0);
        float min = Math.min(1.0f, (float)n / 10.0f);
        Color color = new Color(255, (int)(50.0f + 100.0f * (1.0f - min)), (int)(50.0f + 100.0f * (1.0f - min)));
        return new Color((int)((float)color.getRed() * (float)n3), (int)((float)color.getGreen() * (float)n3), (int)((float)color.getBlue() * (float)n3), (int)(255.0f * n2));
    }

    private void renderInfoBox(class_332 drawContext, int xPos, int yPos, int width, int height, String title, String value, Color color, Color borderColor, float fadeAmount) {
        class_4587 matrices = drawContext.method_51448();
        RenderUtils.renderRoundedQuad(matrices, borderColor, xPos, yPos, xPos + width, yPos + 3, 3.0, 3.0, 0.0, 0.0, 6.0);
        RenderUtils.renderRoundedQuad(matrices, new Color(30, 30, 30, (int)(200.0f * fadeAmount)), xPos, yPos + 3, xPos + width, yPos + height, 0.0, 0.0, 3.0, 3.0, 6.0);
        TextRenderer.drawString(title, drawContext, xPos + width / 2 - TextRenderer.getWidth(title) / 2, yPos + 5, new Color(200, 200, 200, (int)(255.0f * fadeAmount)).getRGB());
        TextRenderer.drawString(value, drawContext, xPos + width / 2 - TextRenderer.getWidth(value) / 2, yPos + height - 17, color.getRGB());
    }

    private Color getHealthColor(float healthPercent, float fadeAmount) {
        Color color;
        if (healthPercent > 0.75f) {
            color = ColorUtil.keyCodec(new Color(100, 255, 100), new Color(255, 255, 100), (1.0f - healthPercent) * 4.0f);
        } else if (healthPercent > 0.25f) {
            color = ColorUtil.keyCodec(new Color(255, 255, 100), new Color(255, 100, 100), (0.75f - healthPercent) * 2.0f);
        } else {
            float pulseIntensity = healthPercent < 0.1f ? (float)((double)0.7f + (double)0.3f * Math.sin((double)System.currentTimeMillis() / 200.0)) : 1.0f;
            color = new Color((int)(255.0f * pulseIntensity), (int)(100.0f * pulseIntensity), (int)(100.0f * pulseIntensity));
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * fadeAmount));
    }

    private Color getPingColor(int ping, float fadeAmount) {
        Color color = ping < 50 ? new Color(100, 255, 100) : (ping < 100 ? ColorUtil.keyCodec(new Color(100, 255, 100), new Color(255, 255, 100), (float)(ping - 50) / 50.0f) : (ping < 200 ? ColorUtil.keyCodec(new Color(255, 255, 100), new Color(255, 150, 50), (float)(ping - 100) / 100.0f) : ColorUtil.keyCodec(new Color(255, 150, 50), new Color(255, 80, 80), Math.min(1.0f, (float)(ping - 200) / 300.0f))));
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * fadeAmount));
    }

    private Color getHurtColor(int hurtTime, float fadeAmount) {
        double pulseIntensity = (double)0.7f + (double)0.3f * Math.sin((double)System.currentTimeMillis() / 150.0);
        float hurtIntensity = Math.min(1.0f, (float)hurtTime / 10.0f);
        Color color = new Color(255, (int)(50.0f + 100.0f * (1.0f - hurtIntensity)), (int)(50.0f + 100.0f * (1.0f - hurtIntensity)));
        return new Color((int)((float)color.getRed() * (float)pulseIntensity), (int)((float)color.getGreen() * (float)pulseIntensity), (int)((float)color.getBlue() * (float)pulseIntensity), (int)(255.0f * fadeAmount));
    }

    @EventListener
    public void onPacketSend(PacketSendEvent packetEvent) {
        class_2596<?> class_25962 = packetEvent.getPacket();
        if (class_25962 instanceof class_2824) {
            class_2824 playerInteractEntityC2SPacket = (class_2824)class_25962;
            if (this.hudHandler == null) {
                this.hudHandler = new TargetHUDHandler(this);
            }
            if (this.hudHandler.isAttackPacket(playerInteractEntityC2SPacket)) {
                this.lastAttackTime = System.currentTimeMillis();
            }
        }
    }

    public static class TargetHUDHandler {
        public static final class_310 MC = class_310.method_1551();
        final TargetHUD this$0;

        TargetHUDHandler(TargetHUD this$0) {
            this.this$0 = this$0;
        }

        public boolean isAttackPacket(class_2824 playerInteractEntityC2SPacket) {
            String string;
            try {
                string = playerInteractEntityC2SPacket.toString();
                if (string.contains("ATTACK")) {
                    return true;
                }
            }
            catch (Exception var5) {
                return TargetHUDHandler.MC.field_1724 != null && TargetHUDHandler.MC.field_1724.method_6052() != null && TargetHUDHandler.MC.field_1724.method_6052() instanceof class_1657;
            }
            try {
                if (TargetHUDHandler.MC.field_1724 == null || TargetHUDHandler.MC.field_1724.method_6052() == null || !(TargetHUDHandler.MC.field_1724.method_6052() instanceof class_1657)) {
                    return false;
                }
                boolean contains = string.contains(class_1268.field_5808.toString());
                boolean contains2 = string.contains("INTERACT_AT");
                if (contains && contains2) {
                    return true;
                }
            }
            catch (Exception var7) {
                return TargetHUDHandler.MC.field_1724 != null && TargetHUDHandler.MC.field_1724.method_6052() != null && TargetHUDHandler.MC.field_1724.method_6052() instanceof class_1657;
            }
            try {
                return TargetHUDHandler.MC.field_1724.field_6252 && TargetHUDHandler.MC.field_1724.method_6052() != null;
            }
            catch (Exception var6) {
                return TargetHUDHandler.MC.field_1724 != null && TargetHUDHandler.MC.field_1724.method_6052() != null && TargetHUDHandler.MC.field_1724.method_6052() instanceof class_1657;
            }
        }
    }
}

