/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.module.modules.render;

import java.awt.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1551;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import skid.gypsyy.event.EventListener;
import skid.gypsyy.event.events.Render3DEvent;
import skid.gypsyy.module.Category;
import skid.gypsyy.module.Module;
import skid.gypsyy.module.setting.BooleanSetting;
import skid.gypsyy.module.setting.NumberSetting;
import skid.gypsyy.utils.EncryptedString;
import skid.gypsyy.utils.RenderUtils;

public final class TridentESP
extends Module {
    private final NumberSetting range = new NumberSetting(EncryptedString.of("Range"), 10.0, 200.0, 100.0, 1.0);
    private final NumberSetting alpha = new NumberSetting(EncryptedString.of("Alpha"), 50.0, 255.0, 200.0, 1.0);
    private final BooleanSetting showDistance = new BooleanSetting(EncryptedString.of("Show Distance"), true).setDescription(EncryptedString.of("Shows distance to the drowned"));
    private final BooleanSetting showHealth = new BooleanSetting(EncryptedString.of("Show Health"), true).setDescription(EncryptedString.of("Shows health of the drowned"));
    private final BooleanSetting onlyTrident = new BooleanSetting(EncryptedString.of("Only Trident"), true).setDescription(EncryptedString.of("Only highlights drowned with tridents"));

    public TridentESP() {
        super(EncryptedString.of("Trident ESP"), EncryptedString.of("Highlights drowned with tridents"), -1, Category.RENDER);
        this.range.setDescription(EncryptedString.of("Range to search for drowned"));
        this.alpha.setDescription(EncryptedString.of("Transparency of the ESP"));
        this.addsettings(this.range, this.alpha, this.showDistance, this.showHealth, this.onlyTrident);
    }

    @EventListener
    public void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724 != null && this.mc.field_1687 != null) {
            class_4184 cam = RenderUtils.getCamera();
            if (cam != null) {
                class_243 camPos = RenderUtils.getCameraPos();
                class_4587 matrices = event.matrixStack;
                matrices.method_22903();
                matrices.method_22907(class_7833.field_40714.rotationDegrees(cam.method_19329()));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(cam.method_19330() + 180.0f));
                matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
            }
            for (class_1297 entity : this.mc.field_1687.method_18112()) {
                double distance;
                if (!(entity instanceof class_1551)) continue;
                class_1551 drowned = (class_1551)entity;
                if (this.onlyTrident.getValue() && !this.hasTrident(drowned) || (distance = (double)this.mc.field_1724.method_5739((class_1297)drowned)) > this.range.getValue()) continue;
                Color color = this.getDrownedColor(drowned, distance);
                float width = drowned.method_17681();
                float height = drowned.method_17682();
                double x = drowned.method_23317();
                double y = drowned.method_23318();
                double z = drowned.method_23321();
                RenderUtils.renderFilledBox(event.matrixStack, (float)(x - (double)(width / 2.0f)), (float)y, (float)(z - (double)(width / 2.0f)), (float)(x + (double)(width / 2.0f)), (float)(y + (double)height), (float)(z + (double)(width / 2.0f)), color);
                RenderUtils.renderLine(event.matrixStack, color, new class_243(x - (double)(width / 2.0f), y, z - (double)(width / 2.0f)), new class_243(x + (double)(width / 2.0f), y + (double)height, z + (double)(width / 2.0f)));
                this.renderEntityOutline(event.matrixStack, x, y, z, width, height, color);
            }
            event.matrixStack.method_22909();
        }
    }

    private boolean hasTrident(class_1551 drowned) {
        class_1799 mainHand = drowned.method_6047();
        if (mainHand.method_7909() == class_1802.field_8547) {
            return true;
        }
        class_1799 offHand = drowned.method_6079();
        return offHand.method_7909() == class_1802.field_8547;
    }

    private Color getDrownedColor(class_1551 drowned, double distance) {
        int red = 255;
        int green = 0;
        int blue = 0;
        double distanceFactor = Math.max(0.0, 1.0 - distance / this.range.getValue());
        red = (int)(255.0 * distanceFactor);
        green = (int)(50.0 * distanceFactor);
        blue = (int)(50.0 * distanceFactor);
        float healthPercent = drowned.method_6032() / drowned.method_6063();
        if (healthPercent < 0.5f) {
            red = (int)(255.0 * distanceFactor);
            green = (int)(165.0 * distanceFactor);
            blue = 0;
        }
        return new Color(red, green, blue, this.alpha.getIntValue());
    }

    private void renderEntityOutline(class_4587 matrices, double x, double y, double z, float width, float height, Color color) {
        RenderUtils.renderLine(matrices, color, new class_243(x - (double)(width / 2.0f), y, z - (double)(width / 2.0f)), new class_243(x - (double)(width / 2.0f), y + (double)height, z - (double)(width / 2.0f)));
        RenderUtils.renderLine(matrices, color, new class_243(x + (double)(width / 2.0f), y, z - (double)(width / 2.0f)), new class_243(x + (double)(width / 2.0f), y + (double)height, z - (double)(width / 2.0f)));
        RenderUtils.renderLine(matrices, color, new class_243(x - (double)(width / 2.0f), y, z + (double)(width / 2.0f)), new class_243(x - (double)(width / 2.0f), y + (double)height, z + (double)(width / 2.0f)));
        RenderUtils.renderLine(matrices, color, new class_243(x + (double)(width / 2.0f), y, z + (double)(width / 2.0f)), new class_243(x + (double)(width / 2.0f), y + (double)height, z + (double)(width / 2.0f)));
        RenderUtils.renderLine(matrices, color, new class_243(x - (double)(width / 2.0f), y + (double)height, z - (double)(width / 2.0f)), new class_243(x + (double)(width / 2.0f), y + (double)height, z - (double)(width / 2.0f)));
        RenderUtils.renderLine(matrices, color, new class_243(x + (double)(width / 2.0f), y + (double)height, z - (double)(width / 2.0f)), new class_243(x + (double)(width / 2.0f), y + (double)height, z + (double)(width / 2.0f)));
        RenderUtils.renderLine(matrices, color, new class_243(x + (double)(width / 2.0f), y + (double)height, z + (double)(width / 2.0f)), new class_243(x - (double)(width / 2.0f), y + (double)height, z + (double)(width / 2.0f)));
        RenderUtils.renderLine(matrices, color, new class_243(x - (double)(width / 2.0f), y + (double)height, z + (double)(width / 2.0f)), new class_243(x - (double)(width / 2.0f), y + (double)height, z - (double)(width / 2.0f)));
    }
}

