/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.utils;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3965;
import net.minecraft.class_4969;
import skid.gypsyy.DonutBBC;

public final class BlockUtil {
    public static Stream<class_2818> getLoadedChunks() {
        int viewRadius = Math.max(2, DonutBBC.mc.field_1690.method_38521()) + 3;
        int diameter = viewRadius * 2 + 1;
        class_1923 centerChunk = DonutBBC.mc.field_1724.method_31476();
        class_1923 minChunk = new class_1923(centerChunk.field_9181 - viewRadius, centerChunk.field_9180 - viewRadius);
        class_1923 maxChunk = new class_1923(centerChunk.field_9181 + viewRadius, centerChunk.field_9180 + viewRadius);
        return Stream.iterate(minChunk, currentPos -> {
            int nextX = currentPos.field_9181;
            int nextZ = currentPos.field_9180;
            if (++nextX > maxChunk.field_9181) {
                nextX = minChunk.field_9181;
                ++nextZ;
            }
            if (nextZ > maxChunk.field_9180) {
                throw new IllegalStateException("Stream limit didn't work.");
            }
            return new class_1923(nextX, nextZ);
        }).limit((long)diameter * (long)diameter).filter(chunkPos -> DonutBBC.mc.field_1687.method_8393(chunkPos.field_9181, chunkPos.field_9180)).map(chunkPos -> DonutBBC.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180)).filter(Objects::nonNull);
    }

    public static Iterable<class_2818> getLoadedChunkss() {
        int viewRadius = Math.max(2, DonutBBC.mc.field_1690.method_38521()) + 3;
        int diameter = viewRadius * 2 + 1;
        class_1923 centerChunk = DonutBBC.mc.field_1724.method_31476();
        class_1923 minChunk = new class_1923(centerChunk.field_9181 - viewRadius, centerChunk.field_9180 - viewRadius);
        class_1923 maxChunk = new class_1923(centerChunk.field_9181 + viewRadius, centerChunk.field_9180 + viewRadius);
        return Stream.iterate(minChunk, currentPos -> {
            int nextX = currentPos.field_9181;
            int nextZ = currentPos.field_9180;
            if (++nextX > maxChunk.field_9181) {
                nextX = minChunk.field_9181;
                ++nextZ;
            }
            if (nextZ > maxChunk.field_9180) {
                throw new IllegalStateException("Stream limit didn't work.");
            }
            return new class_1923(nextX, nextZ);
        }).limit((long)diameter * (long)diameter).filter(chunkPos -> DonutBBC.mc.field_1687.method_8393(chunkPos.field_9181, chunkPos.field_9180)).map(chunkPos -> DonutBBC.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean isBlockAtPosition(class_2338 blockPos, class_2248 block) {
        return DonutBBC.mc.field_1687.method_8320(blockPos).method_26204() == block;
    }

    public static boolean isRespawnAnchorCharged(class_2338 blockPos) {
        return BlockUtil.isBlockAtPosition(blockPos, class_2246.field_23152) && (Integer)DonutBBC.mc.field_1687.method_8320(blockPos).method_11654((class_2769)class_4969.field_23153) != 0;
    }

    public static boolean isRespawnAnchorUncharged(class_2338 blockPos) {
        return BlockUtil.isBlockAtPosition(blockPos, class_2246.field_23152) && (Integer)DonutBBC.mc.field_1687.method_8320(blockPos).method_11654((class_2769)class_4969.field_23153) == 0;
    }

    public static void interactWithBlock(class_3965 blockHitResult, boolean shouldSwingHand) {
        class_1269 result = DonutBBC.mc.field_1761.method_2896(DonutBBC.mc.field_1724, class_1268.field_5808, blockHitResult);
        if (result.method_23665() && result.method_23666() && shouldSwingHand) {
            DonutBBC.mc.field_1724.method_6104(class_1268.field_5808);
        }
    }

    public static boolean canPlaceBlockClient(class_2338 blockPos) {
        return DonutBBC.mc.field_1687.method_8320(blockPos).method_26215();
    }

    public static boolean isBlock(class_2338 blockPos, class_2248 block) {
        return DonutBBC.mc.field_1687.method_8320(blockPos).method_26204() == block;
    }

    public static boolean isAnchorCharged(class_2338 blockPos) {
        return BlockUtil.isRespawnAnchorCharged(blockPos);
    }
}

