/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.utils;

import java.awt.Color;
import skid.gypsyy.utils.MathUtil;

public final class ColorUtil {
    public static Color getRainbowColor(int offset, int alpha) {
        Color hsbColor = Color.getHSBColor((float)((System.currentTimeMillis() * 3L + (long)(offset * 175)) % 7200L) / 7200.0f, 0.6f, 1.0f);
        return new Color(hsbColor.getRed(), hsbColor.getGreen(), hsbColor.getBlue(), alpha);
    }

    public static Color getBreathingColor(Color baseColor, int offset, int speed) {
        float[] hsbValues = new float[3];
        Color.RGBtoHSB(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), hsbValues);
        hsbValues[2] = 0.25f + 0.75f * Math.abs(((float)(System.currentTimeMillis() % 2000L) / 1000.0f + (float)offset / (float)speed * 2.0f) % 2.0f - 1.0f) % 2.0f;
        int rgbValue = Color.HSBtoRGB(hsbValues[0], hsbValues[1], hsbValues[2]);
        return new Color(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF, baseColor.getAlpha());
    }

    public static Color interpolateColors(float interpolation, Color color1, Color color2) {
        return new Color((int)MathUtil.approachValue(interpolation, color2.getRed(), color1.getRed()), (int)MathUtil.approachValue(interpolation, color2.getGreen(), color1.getGreen()), (int)MathUtil.approachValue(interpolation, color2.getBlue(), color1.getBlue()));
    }

    public static Color interpolateAlpha(float interpolation, int targetAlpha, Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)MathUtil.approachValue(interpolation, color.getAlpha(), targetAlpha));
    }

    public static Color smoothInterpolate(Color color1, Color color2, float interpolation) {
        return new Color(ColorUtil.clampValue(Math.round((float)color1.getRed() + interpolation * (float)(color2.getRed() - color1.getRed())), 0, 255), ColorUtil.clampValue(Math.round((float)color1.getGreen() + interpolation * (float)(color2.getGreen() - color1.getGreen())), 0, 255), ColorUtil.clampValue(Math.round((float)color1.getBlue() + interpolation * (float)(color2.getBlue() - color1.getBlue())), 0, 255), ColorUtil.clampValue(Math.round((float)color1.getAlpha() + interpolation * (float)(color2.getAlpha() - color1.getAlpha())), 0, 255));
    }

    private static int clampValue(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static Color keyCodec(int offset, int alpha) {
        return ColorUtil.getRainbowColor(offset, alpha);
    }

    public static Color keyCodec(float interpolation, Color color1, Color color2) {
        return ColorUtil.interpolateColors(interpolation, color1, color2);
    }

    public static Color keyCodec(float interpolation, int targetAlpha, Color color) {
        return ColorUtil.interpolateAlpha(interpolation, targetAlpha, color);
    }

    public static Color keyCodec(Color color1, Color color2, float interpolation) {
        return ColorUtil.smoothInterpolate(color1, color2, interpolation);
    }
}

