/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.utils;

import java.awt.Color;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class EnhancedShaderRenderer {
    private static int shaderProgram;
    private static int VAO;
    private static int VBO;
    private static boolean initialized;
    private static int u_resolution;
    private static int u_position;
    private static int u_size;
    private static int u_color;
    private static int u_cornerRadii;
    private static int u_borderWidth;
    private static int u_borderColor;

    public static void init() {
        if (!initialized) {
            String vertexShaderSource = "#version 330 core\nlayout (location = 0) in vec2 aPos;\nout vec2 fragCoord;\nuniform vec2 u_resolution;\nvoid main() {\n    fragCoord = (aPos + 1.0) * 0.5 * u_resolution;\n    gl_Position = vec4(aPos, 0.0, 1.0);\n}";
            String fragmentShaderSource = "#version 330 core\nuniform vec2 u_resolution;\nuniform vec2 u_position;\nuniform vec2 u_size;\nuniform vec4 u_color;\nuniform vec4 u_cornerRadii;\nuniform float u_borderWidth;\nuniform vec4 u_borderColor;\nin vec2 fragCoord;\nout vec4 fragColor;\n\nfloat roundedBoxSDF(vec2 centerPos, vec2 size, vec4 radius) {\n    radius.xy = (centerPos.x > 0.0) ? radius.xy : radius.zw;\n    radius.x = (centerPos.y > 0.0) ? radius.x : radius.y;\n    vec2 q = abs(centerPos) - size + radius.x;\n    return min(max(q.x, q.y), 0.0) + length(max(q, 0.0)) - radius.x;\n}\n\nvoid main() {\n    vec2 halfSize = u_size * 0.5;\n    vec2 centerPos = fragCoord - u_position - halfSize;\n    float distance = roundedBoxSDF(centerPos, halfSize, u_cornerRadii);\n    float alpha = 1.0 - smoothstep(-1.0, 1.0, distance);\n    \n    if (u_borderWidth > 0.0) {\n        float borderDistance = abs(distance) - u_borderWidth * 0.5;\n        float borderAlpha = 1.0 - smoothstep(-1.0, 1.0, borderDistance);\n        vec4 finalColor = mix(u_color, u_borderColor, step(0.0, distance - u_borderWidth * 0.5));\n        fragColor = vec4(finalColor.rgb, finalColor.a * alpha * borderAlpha);\n    } else {\n        fragColor = vec4(u_color.rgb, u_color.a * alpha);\n    }\n}";
            try {
                shaderProgram = EnhancedShaderRenderer.createShaderProgram(vertexShaderSource, fragmentShaderSource);
                u_resolution = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"u_resolution");
                u_position = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"u_position");
                u_size = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"u_size");
                u_color = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"u_color");
                u_cornerRadii = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"u_cornerRadii");
                u_borderWidth = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"u_borderWidth");
                u_borderColor = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"u_borderColor");
                EnhancedShaderRenderer.setupQuad();
                initialized = true;
            }
            catch (Exception var3) {
                System.err.println("Failed to initialize EnhancedShaderRenderer: " + var3.getMessage());
                var3.printStackTrace();
            }
        }
    }

    private static void setupQuad() {
        float[] vertices = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
        VAO = GL30.glGenVertexArrays();
        VBO = GL15.glGenBuffers();
        GL30.glBindVertexArray((int)VAO);
        GL15.glBindBuffer((int)34962, (int)VBO);
        GL15.glBufferData((int)34962, (float[])vertices, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)8, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
    }

    public static void renderRoundedRect(class_4587 matrices, Color color, float x, float y, float width, float height, float radius) {
        EnhancedShaderRenderer.renderRoundedRect(matrices, color, x, y, width, height, radius, radius, radius, radius, 0.0f, null);
    }

    public static void renderRoundedRect(class_4587 matrices, Color color, float x, float y, float width, float height, float topLeft, float topRight, float bottomLeft, float bottomRight, float borderWidth, Color borderColor) {
        if (!initialized) {
            EnhancedShaderRenderer.init();
        }
        if (shaderProgram != 0) {
            try {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL20.glUseProgram((int)shaderProgram);
                float screenWidth = class_310.method_1551().method_22683().method_4489();
                float screenHeight = class_310.method_1551().method_22683().method_4506();
                GL20.glUniform2f((int)u_resolution, (float)screenWidth, (float)screenHeight);
                GL20.glUniform2f((int)u_position, (float)x, (float)(screenHeight - y - height));
                GL20.glUniform2f((int)u_size, (float)width, (float)height);
                GL20.glUniform4f((int)u_color, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                GL20.glUniform4f((int)u_cornerRadii, (float)topLeft, (float)topRight, (float)bottomLeft, (float)bottomRight);
                if (borderWidth > 0.0f && borderColor != null) {
                    GL20.glUniform1f((int)u_borderWidth, (float)borderWidth);
                    GL20.glUniform4f((int)u_borderColor, (float)((float)borderColor.getRed() / 255.0f), (float)((float)borderColor.getGreen() / 255.0f), (float)((float)borderColor.getBlue() / 255.0f), (float)((float)borderColor.getAlpha() / 255.0f));
                } else {
                    GL20.glUniform1f((int)u_borderWidth, (float)0.0f);
                    GL20.glUniform4f((int)u_borderColor, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glScissor((int)((int)x), (int)((int)(screenHeight - y - height)), (int)((int)width), (int)((int)height));
                GL11.glEnable((int)3089);
                GL30.glBindVertexArray((int)VAO);
                GL11.glDrawArrays((int)4, (int)0, (int)6);
                GL30.glBindVertexArray((int)0);
                GL11.glDisable((int)3089);
                GL20.glUseProgram((int)0);
                GL11.glDisable((int)3042);
            }
            catch (Exception var14) {
                System.err.println("Error rendering rounded rect: " + var14.getMessage());
            }
        }
    }

    private static int createShaderProgram(String vertexSource, String fragmentSource) {
        int vertexShader = EnhancedShaderRenderer.compileShader(35633, vertexSource);
        int fragmentShader = EnhancedShaderRenderer.compileShader(35632, fragmentSource);
        int program = GL20.glCreateProgram();
        GL20.glAttachShader((int)program, (int)vertexShader);
        GL20.glAttachShader((int)program, (int)fragmentShader);
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            throw new RuntimeException("Failed to link shader program: " + GL20.glGetProgramInfoLog((int)program));
        }
        GL20.glDeleteShader((int)vertexShader);
        GL20.glDeleteShader((int)fragmentShader);
        return program;
    }

    private static int compileShader(int type, String source) {
        int shader = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)shader, (CharSequence)source);
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            throw new RuntimeException("Failed to compile shader: " + GL20.glGetShaderInfoLog((int)shader));
        }
        return shader;
    }

    public static void cleanup() {
        if (initialized) {
            GL20.glDeleteProgram((int)shaderProgram);
            GL30.glDeleteVertexArrays((int)VAO);
            GL15.glDeleteBuffers((int)VBO);
            initialized = false;
        }
    }

    static {
        initialized = false;
    }
}

