/*
 * Decompiled with CFR 0.152.
 */
package skid.gypsyy.utils;

import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_9779;
import skid.gypsyy.DonutBBC;

public final class WorldUtils {
    private static final class_310 mc = DonutBBC.mc;

    public static boolean isDeadBodyNearby() {
        return WorldUtils.mc.field_1687.method_18456().parallelStream().filter(player -> player != WorldUtils.mc.field_1724).filter(player -> player.method_5858((class_1297)WorldUtils.mc.field_1724) <= 36.0).anyMatch(class_1309::method_29504);
    }

    public static class_1297 findNearestEntity(class_1657 targetPlayer, float radius, boolean seeOnly) {
        float minDistance = Float.MAX_VALUE;
        class_1297 nearestEntity = null;
        assert (WorldUtils.mc.field_1687 != null);
        for (class_1297 entity : WorldUtils.mc.field_1687.method_18112()) {
            float distance = entity.method_5739((class_1297)targetPlayer);
            if (entity == targetPlayer || !(distance <= radius) || WorldUtils.mc.field_1724.method_6057(entity) != seeOnly || !(distance < minDistance)) continue;
            minDistance = distance;
            nearestEntity = entity;
        }
        return nearestEntity;
    }

    public static double getDistance(class_243 fromVec, class_243 toVec) {
        return Math.sqrt(Math.pow(toVec.field_1352 - fromVec.field_1352, 2.0) + Math.pow(toVec.field_1351 - fromVec.field_1351, 2.0) + Math.pow(toVec.field_1350 - fromVec.field_1350, 2.0));
    }

    public static class_1657 findNearestPlayer(class_1657 targetPlayer, float range, boolean seeOnly, boolean excludeFriends) {
        float minDistance = Float.MAX_VALUE;
        class_1657 nearestPlayer = null;
        for (class_1657 player : WorldUtils.mc.field_1687.method_18456()) {
            float distance = (float)WorldUtils.getDistance(targetPlayer.method_19538(), player.method_19538());
            if (player == targetPlayer || !(distance <= range) || player.method_6057((class_1297)targetPlayer) != seeOnly || !(distance < minDistance)) continue;
            minDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    public static class_243 getPlayerLookVec(float yaw, float pitch) {
        float pitchRadians = pitch * ((float)Math.PI / 180);
        float yawRadians = -yaw * ((float)Math.PI / 180);
        float cosYaw = class_3532.method_15362((float)yawRadians);
        float sinYaw = class_3532.method_15374((float)yawRadians);
        float cosPitch = class_3532.method_15362((float)pitchRadians);
        float sinPitch = class_3532.method_15374((float)pitchRadians);
        return new class_243((double)(sinYaw * cosPitch), (double)(-sinPitch), (double)(cosYaw * cosPitch));
    }

    public static class_243 getPlayerLookVec(class_1657 player) {
        return WorldUtils.getPlayerLookVec(player.method_36454(), player.method_36455());
    }

    public static class_239 getHitResult(double radius) {
        return WorldUtils.getHitResult((class_1657)WorldUtils.mc.field_1724, false, WorldUtils.mc.field_1724.method_36454(), WorldUtils.mc.field_1724.method_36455(), radius);
    }

    public static class_239 getHitResult(class_1657 entity, boolean ignoreInvisibles, float yaw, float pitch, double distance) {
        if (entity != null && WorldUtils.mc.field_1687 != null) {
            class_238 box;
            class_243 vec3d3;
            class_3966 entityHitResult;
            class_243 cameraPosVec = entity.method_5836(class_9779.field_51956.method_60637(true));
            class_243 rotationVec = WorldUtils.getPlayerLookVec(yaw, pitch);
            class_243 range = cameraPosVec.method_1031(rotationVec.field_1352 * distance, rotationVec.field_1351 * distance, rotationVec.field_1350 * distance);
            class_3965 result = WorldUtils.mc.field_1687.method_17742(new class_3959(cameraPosVec, range, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)entity));
            double squaredDistance = distance * distance;
            if (result != null) {
                squaredDistance = result.method_17784().method_1025(cameraPosVec);
            }
            if ((entityHitResult = class_1675.method_18075((class_1297)entity, (class_243)cameraPosVec, (class_243)(vec3d3 = cameraPosVec.method_1031(rotationVec.field_1352 * distance, rotationVec.field_1351 * distance, rotationVec.field_1350 * distance)), (class_238)(box = entity.method_5829().method_18804(rotationVec.method_1021(distance)).method_1009(1.0, 1.0, 1.0)), entityx -> !entityx.method_7325() && entityx.method_5863() && (!entityx.method_5767() || !ignoreInvisibles), (double)squaredDistance)) != null) {
                class_243 vec3d4 = entityHitResult.method_17784();
                double entitySquaredDistance = cameraPosVec.method_1025(vec3d4);
                if (distance > distance && entitySquaredDistance > Math.pow(distance, 2.0) || entitySquaredDistance < squaredDistance || result == null) {
                    result = entitySquaredDistance > Math.pow(distance, 2.0) ? class_3965.method_17778((class_243)vec3d4, (class_2350)class_2350.method_10142((double)rotationVec.field_1352, (double)rotationVec.field_1351, (double)rotationVec.field_1350), (class_2338)class_2338.method_49638((class_2374)vec3d4)) : entityHitResult;
                }
            }
            return result;
        }
        return null;
    }

    public static void placeBlock(class_3965 blockHit, boolean swingHand) {
        class_1269 result = WorldUtils.mc.field_1761.method_2896(WorldUtils.mc.field_1724, class_1268.field_5808, blockHit);
        if (result.method_23665() && result.method_23666() && swingHand) {
            WorldUtils.mc.field_1724.method_6104(class_1268.field_5808);
        }
    }

    public static Stream<class_2818> getLoadedChunks() {
        int viewRadius = Math.max(2, WorldUtils.mc.field_1690.method_38521()) + 3;
        int diameter = viewRadius * 2 + 1;
        class_1923 centerChunk = WorldUtils.mc.field_1724.method_31476();
        class_1923 minChunk = new class_1923(centerChunk.field_9181 - viewRadius, centerChunk.field_9180 - viewRadius);
        class_1923 maxChunk = new class_1923(centerChunk.field_9181 + viewRadius, centerChunk.field_9180 + viewRadius);
        return Stream.iterate(minChunk, currentPos -> {
            int nextX = currentPos.field_9181;
            int nextZ = currentPos.field_9180;
            if (++nextX > maxChunk.field_9181) {
                nextX = minChunk.field_9181;
                ++nextZ;
            }
            if (nextZ > maxChunk.field_9180) {
                throw new IllegalStateException("Stream limit didn't work.");
            }
            return new class_1923(nextX, nextZ);
        }).limit((long)diameter * (long)diameter).filter(chunkPos -> WorldUtils.mc.field_1687.method_8393(chunkPos.field_9181, chunkPos.field_9180)).map(chunkPos -> WorldUtils.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180)).filter(Objects::nonNull);
    }

    public static boolean isShieldFacingAway(class_1657 player) {
        if (WorldUtils.mc.field_1724 != null && player != null) {
            class_243 playerPos = WorldUtils.mc.field_1724.method_19538();
            class_243 targetPos = player.method_19538();
            class_243 directionToPlayer = playerPos.method_1020(targetPos).method_1029();
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            class_243 facingDirection = new class_243(-Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)), -Math.sin(Math.toRadians(pitch)), Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch))).method_1029();
            double dotProduct = facingDirection.method_1026(directionToPlayer);
            return dotProduct < 0.0;
        }
        return false;
    }

    public static boolean isTool(class_1799 itemStack) {
        if (!(itemStack.method_7909() instanceof class_1831)) {
            return false;
        }
        class_1832 material = ((class_1831)itemStack.method_7909()).method_8022();
        return material == class_1834.field_8930 || material == class_1834.field_22033;
    }

    public static boolean isCrit(class_1657 player, class_1297 target) {
        return player.method_7261(0.5f) > 0.9f && player.field_6017 > 0.0f && !player.method_24828() && !player.method_6101() && !player.method_5869() && !player.method_6059(class_1294.field_5919) && target instanceof class_1309;
    }

    public static void hitEntity(class_1297 entity, boolean swingHand) {
        WorldUtils.mc.field_1761.method_2918((class_1657)WorldUtils.mc.field_1724, entity);
        if (swingHand) {
            WorldUtils.mc.field_1724.method_6104(class_1268.field_5808);
        }
    }
}

